/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datastructures;

import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.Cluster;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.Item;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rminfo.RMPropertyIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ITEM_TABLE", propOrder={"rows"})
@XmlRootElement(name="item_table")
public class ItemTable
extends ItemStructure {
    @Nullable
    private List<Cluster> rows = new ArrayList<Cluster>();

    public ItemTable() {
    }

    public ItemTable(String archetypeNodeId, DvText name, @Nullable List<Cluster> rows) {
        super(archetypeNodeId, name);
        this.setRows(rows);
    }

    public ItemTable(@Nullable UIDBasedId uid, String archetypeNodeId, DvText name, @Nullable Archetyped archetypeDetails, @Nullable FeederAudit feederAudit, @Nullable List<Link> links, @Nullable Pathable parent, @Nullable String parentAttributeName, @Nullable List<Cluster> rows) {
        super(uid, archetypeNodeId, name, archetypeDetails, feederAudit, links, parent, parentAttributeName);
        this.setRows(rows);
    }

    public List<Cluster> getRows() {
        return this.rows;
    }

    public void setRows(List<Cluster> rows) {
        this.rows = rows;
        this.setThisAsParent(rows, "rows");
    }

    public void addItem(Cluster row) {
        this.rows.add(row);
        this.setThisAsParent(row, "rows");
    }

    @RMPropertyIgnore
    public List<Element> getItems() {
        if (this.rows == null) {
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (Cluster row : this.rows) {
            for (Item element : row.getItems()) {
                result.add((Element)element);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ItemTable itemTable = (ItemTable)o;
        return Objects.equals(this.rows, itemTable.rows);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rows);
    }

    @Invariant(value="Valid_structure")
    public boolean validStructure() {
        if (this.rows != null) {
            for (Cluster row : this.rows) {
                if (row.getItems() == null) continue;
                for (Item item : row.getItems()) {
                    if (item instanceof Element) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Invariant(value="Valid_number_of_rows")
    public boolean validNumberOfRows() {
        if (this.rows != null) {
            Integer size = null;
            for (Cluster row : this.rows) {
                if (row.getItems() == null) continue;
                if (size == null) {
                    size = row.getItems().size();
                    continue;
                }
                if (size.intValue() == row.getItems().size()) continue;
                return false;
            }
        }
        return true;
    }
}

