/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DataValue;
import com.nedap.archie.rm.datavalues.DvURI;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.datavalues.TermMapping;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_TEXT", propOrder={"value", "hyperlink", "formatting", "mappings", "language", "encoding"})
public class DvText
extends DataValue
implements SingleValuedDataValue<String> {
    private String value;
    @Nullable
    private DvURI hyperlink;
    @Nullable
    private String formatting;
    @Nullable
    private List<TermMapping> mappings = new ArrayList<TermMapping>();
    @Nullable
    private CodePhrase language;
    @Nullable
    private CodePhrase encoding;

    public DvText() {
    }

    public DvText(String value) {
        this.value = value;
    }

    public DvText(String value, @Nullable CodePhrase language, @Nullable CodePhrase encoding) {
        this.value = value;
        this.language = language;
        this.encoding = encoding;
    }

    public List<TermMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<TermMapping> mappings) {
        this.mappings = mappings;
    }

    public void addMapping(TermMapping mapping) {
        this.mappings.add(mapping);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public DvURI getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(DvURI hyperlink) {
        this.hyperlink = hyperlink;
    }

    @Nullable
    public String getFormatting() {
        return this.formatting;
    }

    public void setFormatting(@Nullable String formatting) {
        this.formatting = formatting;
    }

    public CodePhrase getLanguage() {
        return this.language;
    }

    public void setLanguage(CodePhrase language) {
        this.language = language;
    }

    public CodePhrase getEncoding() {
        return this.encoding;
    }

    public void setEncoding(CodePhrase encoding) {
        this.encoding = encoding;
    }

    @Invariant(value="Language_valid")
    public boolean languageValid() {
        return InvariantUtil.belongsToTerminologyByOpenEHRId(this.language, "languages");
    }

    @Invariant(value="Encoding_valid")
    public boolean encodingValid() {
        return InvariantUtil.belongsToTerminologyByOpenEHRId(this.encoding, "character sets");
    }

    @Invariant(value="Mappings_valid", ignored=true)
    public boolean mappingsValid() {
        return InvariantUtil.nullOrNotEmpty(this.mappings);
    }

    @Invariant(value="Formatting_valid")
    public boolean formattingValid() {
        return InvariantUtil.nullOrNotEmpty(this.formatting);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DvText dvText = (DvText)o;
        return Objects.equals(this.value, dvText.value) && Objects.equals(this.hyperlink, dvText.hyperlink) && Objects.equals(this.formatting, dvText.formatting) && Objects.equals(this.mappings, dvText.mappings) && Objects.equals(this.language, dvText.language) && Objects.equals(this.encoding, dvText.encoding);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.hyperlink, this.formatting, this.mappings, this.language, this.encoding);
    }
}

