/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues;

import com.google.common.collect.Sets;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import com.nedap.archie.xml.adapters.TermMappingMatchAdapter;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TERM_MAPPING", propOrder={"match", "purpose", "target"})
public class TermMapping
extends RMObject {
    private static final Set<Character> VALID_MATCH_CODES = Sets.newHashSet((Object[])new Character[]{Character.valueOf('<'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('?')});
    @XmlJavaTypeAdapter(value=TermMappingMatchAdapter.class)
    private Character match = Character.valueOf('?');
    @Nullable
    private DvCodedText purpose;
    private CodePhrase target;

    public TermMapping() {
    }

    public TermMapping(CodePhrase target, Character match, @Nullable DvCodedText purpose) {
        this.match = match;
        this.purpose = purpose;
        this.target = target;
    }

    public char getMatch() {
        return this.match.charValue();
    }

    public void setMatch(char match) {
        this.match = Character.valueOf(match);
    }

    @Nullable
    public DvCodedText getPurpose() {
        return this.purpose;
    }

    public void setPurpose(@Nullable DvCodedText purpose) {
        this.purpose = purpose;
    }

    public CodePhrase getTarget() {
        return this.target;
    }

    public void setTarget(CodePhrase target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermMapping that = (TermMapping)o;
        return Objects.equals(this.match, that.match) && Objects.equals(this.purpose, that.purpose) && Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        return Objects.hash(this.match, this.purpose, this.target);
    }

    @Invariant(value="Purpose_valid")
    public boolean purposeValid() {
        return InvariantUtil.belongsToTerminologyByGroupId(this.purpose, "term mapping purpose");
    }

    @Invariant(value="Match_valid")
    public boolean matchValid() {
        return this.match == null || VALID_MATCH_CODES.contains(this.match);
    }
}

