/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.encapsulated;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.datavalues.encapsulated.DvEncapsulated;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.io.Charsets;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_PARSABLE", propOrder={"value", "formalism"})
public class DvParsable
extends DvEncapsulated
implements SingleValuedDataValue<String> {
    private String value;
    private String formalism;

    public DvParsable() {
    }

    public DvParsable(String value, String formalism) {
        this.value = value;
        this.formalism = formalism;
    }

    public DvParsable(@Nullable CodePhrase charset, @Nullable CodePhrase language, String value, String formalism) {
        super(charset, language);
        this.value = value;
        this.formalism = formalism;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public String getFormalism() {
        return this.formalism;
    }

    public void setFormalism(String formalism) {
        this.formalism = formalism;
    }

    public int size() {
        if (this.value == null) {
            return 0;
        }
        if (this.getCharset() != null) {
            return this.value.getBytes(Charsets.toCharset((String)this.getCharset().getCodeString())).length;
        }
        return this.value.getBytes(StandardCharsets.UTF_8).length;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DvParsable that = (DvParsable)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.formalism, that.formalism);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.formalism);
    }

    @Invariant(value="Formalism_valid")
    public boolean formalismValid() {
        return InvariantUtil.nullOrNotEmpty(this.formalism);
    }

    @Invariant(value="Size_valid", ignored=true)
    public boolean sizeValid() {
        return this.size() >= 0;
    }
}

