/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DataValue;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rminfo.RMPropertyIgnore;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_ORDERED", propOrder={"normalRange", "otherReferenceRanges", "normalStatus"})
public abstract class DvOrdered<DataValueType extends DvOrdered<DataValueType>>
extends DataValue
implements Comparable<DataValueType> {
    @Nullable
    @XmlElement(name="normal_status")
    private CodePhrase normalStatus;
    @Nullable
    @XmlElement(name="normal_range")
    private DvInterval<DataValueType> normalRange;
    @Nullable
    @XmlElement(name="other_reference_ranges")
    private List<ReferenceRange<DataValueType>> otherReferenceRanges = new ArrayList<ReferenceRange<DataValueType>>();

    public DvOrdered() {
    }

    public DvOrdered(@Nullable List<ReferenceRange<DataValueType>> otherReferenceRanges, @Nullable DvInterval<DataValueType> normalRange) {
        this.normalRange = normalRange;
        this.otherReferenceRanges = otherReferenceRanges;
    }

    protected DvOrdered(@Nullable List<ReferenceRange<DataValueType>> otherReferenceRanges, @Nullable DvInterval<DataValueType> normalRange, @Nullable CodePhrase normalStatus) {
        this.normalStatus = normalStatus;
        this.normalRange = normalRange;
        this.otherReferenceRanges = otherReferenceRanges;
    }

    public DvInterval<DataValueType> getNormalRange() {
        return this.normalRange;
    }

    public void setNormalRange(DvInterval<DataValueType> normalRange) {
        this.normalRange = normalRange;
    }

    public List<ReferenceRange<DataValueType>> getOtherReferenceRanges() {
        return this.otherReferenceRanges;
    }

    public void setOtherReferenceRanges(List<ReferenceRange<DataValueType>> otherReferenceRanges) {
        this.otherReferenceRanges = otherReferenceRanges;
    }

    public void addOtherReferenceRange(ReferenceRange<DataValueType> range) {
        this.otherReferenceRanges.add(range);
    }

    @Nullable
    public CodePhrase getNormalStatus() {
        return this.normalStatus;
    }

    public void setNormalStatus(@Nullable CodePhrase normalStatus) {
        this.normalStatus = normalStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DvOrdered dvOrdered = (DvOrdered)o;
        return Objects.equals(this.normalStatus, dvOrdered.normalStatus) && Objects.equals(this.normalRange, dvOrdered.normalRange) && Objects.equals(this.otherReferenceRanges, dvOrdered.otherReferenceRanges);
    }

    @JsonIgnore
    @XmlTransient
    @RMPropertyIgnore
    public boolean isSimple() {
        return this.normalRange == null && (this.otherReferenceRanges == null || this.otherReferenceRanges.isEmpty());
    }

    public int hashCode() {
        return Objects.hash(this.normalStatus, this.normalRange, this.otherReferenceRanges);
    }

    @Invariant(value="Other_reference_ranges_validity", ignored=true)
    public boolean otherReferenceRangesValid() {
        return InvariantUtil.nullOrNotEmpty(this.otherReferenceRanges);
    }

    @Invariant(value="Is_simple_validity", ignored=true)
    public boolean simpleValiditiy() {
        return true;
    }

    @Invariant(value="Normal_status_validity")
    public boolean normalStatusValidity() {
        return InvariantUtil.belongsToTerminologyByOpenEHRId(this.normalStatus, "normal statuses");
    }

    @Invariant(value="Normal_range_and_status_consistency")
    public boolean normalRangeAndStatusConsistency() {
        if (this.normalStatus != null && this.normalRange != null) {
            return Objects.equals(this.normalStatus.getCodeString(), "N") ^ !this.normalRange.has(this);
        }
        return true;
    }
}

