/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.quantity.DvAmount;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.ProportionKind;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import com.nedap.archie.rminfo.Invariant;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_PROPORTION", propOrder={"numerator", "denominator", "type", "precision"})
public class DvProportion
extends DvAmount<DvProportion, Double> {
    private Double numerator;
    private Double denominator;
    private Long type;
    @Nullable
    private Long precision;

    public DvProportion() {
    }

    public DvProportion(Double numerator, Double denominator, Long type) {
        this(numerator, denominator, type, null);
    }

    public DvProportion(Double numerator, Double denominator, Long type, Long precision) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.type = type;
        this.precision = precision;
    }

    public DvProportion(@Nullable List<ReferenceRange<DvProportion>> otherReferenceRanges, @Nullable DvInterval<DvProportion> normalRange, @Nullable CodePhrase normalStatus, @Nullable Double accuracy, @Nullable Boolean accuracyIsPercent, @Nullable String magnitudeStatus, Double numerator, Double denominator, Long type, @Nullable Long precision) {
        super(otherReferenceRanges, normalRange, normalStatus, accuracy, accuracyIsPercent, magnitudeStatus);
        this.numerator = numerator;
        this.denominator = denominator;
        this.type = type;
        this.precision = precision;
    }

    public Double getNumerator() {
        return this.numerator;
    }

    public void setNumerator(Double numerator) {
        this.numerator = numerator;
    }

    public Double getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Double denominator) {
        this.denominator = denominator;
    }

    public Long getType() {
        return this.type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    @Nullable
    public Long getPrecision() {
        return this.precision;
    }

    public void setPrecision(@Nullable Long precision) {
        this.precision = precision;
    }

    private static boolean isInteger(Double value) {
        return value == Math.floor(value) && !Double.isInfinite(value);
    }

    @JsonIgnore
    public boolean isIntegral() {
        return this.numerator != null && this.denominator != null && DvProportion.isInteger(this.numerator) && DvProportion.isInteger(this.denominator);
    }

    @Override
    @JsonIgnore
    public Double getMagnitude() {
        if (this.numerator != null && this.denominator != null && this.denominator != 0.0) {
            return this.numerator / this.denominator;
        }
        if (this.numerator == null) {
            return 0.0;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DvProportion that = (DvProportion)o;
        return Objects.equals(this.numerator, that.numerator) && Objects.equals(this.denominator, that.denominator) && Objects.equals(this.type, that.type) && Objects.equals(this.precision, that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numerator, this.denominator, this.type, this.precision);
    }

    @Invariant(value="Type_validity")
    public boolean typeValid() {
        if (this.type != null) {
            return this.type >= 0L && this.type <= 4L;
        }
        return true;
    }

    @Invariant(value="Precision_validity")
    public boolean precisionValid() {
        if (this.precision != null && this.precision == 0L && this.denominator != null && this.numerator != null) {
            return this.isIntegral();
        }
        return true;
    }

    @Invariant(value="Is_integral_validity", ignored=true)
    public boolean integralValidity() {
        if (this.isIntegral() && this.denominator != null && this.numerator != null) {
            return !(!this.numerator.equals(Math.floor(this.numerator)) && !Double.isInfinite(this.numerator) || !this.denominator.equals(Math.floor(this.denominator)) && !Double.isFinite(this.denominator));
        }
        return true;
    }

    @Invariant(value="Fraction_validity")
    public boolean fractionValidity() {
        if (this.type != null && (this.type.equals(ProportionKind.FRACTION.getPk()) || this.type.equals(ProportionKind.INTEGER_FRACTION.getPk()))) {
            return this.isIntegral();
        }
        return true;
    }

    @Invariant(value="Unitary_validity")
    public boolean unitaryValidity() {
        if (this.type != null && this.denominator != null && this.type.equals(ProportionKind.UNITARY.getPk())) {
            return this.denominator.equals(1.0);
        }
        return true;
    }

    @Invariant(value="Percent_validity")
    public boolean percentValidity() {
        if (this.type != null && this.denominator != null && this.type.equals(ProportionKind.PERCENT.getPk())) {
            return this.denominator.equals(100.0);
        }
        return true;
    }

    @Invariant(value="Valid_denominator")
    public boolean denominatorValid() {
        if (this.denominator != null) {
            return !this.denominator.equals(0.0);
        }
        return true;
    }
}

