/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity.datetime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.datavalues.quantity.DvAmount;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import com.nedap.archie.rm.datavalues.quantity.datetime.TimeDefinitions;
import com.nedap.archie.xml.adapters.DurationXmlAdapter;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_DURATION", propOrder={"value"})
public class DvDuration
extends DvAmount<DvDuration, Double>
implements SingleValuedDataValue<TemporalAmount> {
    @XmlJavaTypeAdapter(value=DurationXmlAdapter.class)
    private TemporalAmount value;

    public DvDuration() {
    }

    public DvDuration(TemporalAmount value) {
        this.value = value;
    }

    public DvDuration(String iso8601Duration) {
        this.value = DateTimeParsers.parseDurationValue((String)iso8601Duration);
    }

    public DvDuration(@Nullable List<ReferenceRange<DvDuration>> otherReferenceRanges, @Nullable DvInterval<DvDuration> normalRange, @Nullable CodePhrase normalStatus, @Nullable Double accuracy, @Nullable Boolean accuracyIsPercent, @Nullable String magnitudeStatus, TemporalAmount value) {
        super(otherReferenceRanges, normalRange, normalStatus, accuracy, accuracyIsPercent, magnitudeStatus);
        this.value = value;
    }

    @Override
    public TemporalAmount getValue() {
        return this.value;
    }

    @Override
    public void setValue(TemporalAmount value) {
        this.value = value;
    }

    @Override
    @XmlTransient
    @JsonIgnore
    public Double getMagnitude() {
        if (this.value == null) {
            return null;
        }
        return TimeDefinitions.convertTemporalAmountToSeconds(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DvDuration that = (DvDuration)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

