/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity.datetime;

import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;

public class TimeDefinitions {
    public static double NOMINAL_DAYS_IN_YEAR = 365.24;
    public static double NOMINAL_DAYS_IN_MONTH = 30.42;
    public static int HOURS_IN_DAY = 24;
    public static int MINUTES_IN_HOUR = 60;
    public static int SECONDS_IN_MINUTE = 60;
    public static int SECONDS_IN_DAY = HOURS_IN_DAY * MINUTES_IN_HOUR * SECONDS_IN_MINUTE;
    public static double NOMINAL_SECONDS_IN_MONTH = NOMINAL_DAYS_IN_MONTH * (double)SECONDS_IN_DAY;
    public static double NOMINAL_SECONDS_IN_YEAR = NOMINAL_DAYS_IN_YEAR * (double)SECONDS_IN_DAY;

    public static Double convertTemporalAmountToSeconds(TemporalAmount amount) {
        double result = 0.0;
        for (TemporalUnit unit : amount.getUnits()) {
            if (unit instanceof ChronoUnit) {
                ChronoUnit chronoUnit = (ChronoUnit)unit;
                switch (chronoUnit) {
                    case MONTHS: {
                        result += (double)amount.get(unit) * NOMINAL_SECONDS_IN_MONTH;
                        break;
                    }
                    case YEARS: {
                        result += (double)amount.get(unit) * NOMINAL_SECONDS_IN_YEAR;
                        break;
                    }
                    case DECADES: {
                        result += (double)(amount.get(unit) * 10L) * NOMINAL_SECONDS_IN_YEAR;
                        break;
                    }
                    case CENTURIES: {
                        result += (double)(amount.get(unit) * 100L) * NOMINAL_SECONDS_IN_YEAR;
                        break;
                    }
                    case MILLENNIA: {
                        result += (double)(amount.get(unit) * 1000L) * NOMINAL_SECONDS_IN_YEAR;
                        break;
                    }
                    default: {
                        double toAdd = chronoUnit.getDuration().getSeconds();
                        result += (double)amount.get(unit) * (toAdd += (double)chronoUnit.getDuration().getNano() / 1.0E9);
                        break;
                    }
                }
                continue;
            }
            double toAdd = unit.getDuration().getSeconds();
            result += (double)amount.get(unit) * (toAdd += (double)unit.getDuration().getNano() / 1000000.0);
        }
        return result;
    }
}

