/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.ehr;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="EHR")
@XmlType(name="EHR", propOrder={"systemId", "ehrId", "timeCreated", "contributions", "ehrAccess", "ehrStatus", "directory", "compositions", "folders"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Ehr
extends RMObject {
    @XmlElement(name="system_id")
    private HierObjectId systemId;
    @XmlElement(name="ehr_id")
    private HierObjectId ehrId;
    private List<ObjectRef<? extends ObjectId>> contributions = new ArrayList<ObjectRef<? extends ObjectId>>();
    @XmlElement(name="ehr_status")
    private ObjectRef<? extends ObjectId> ehrStatus;
    @XmlElement(name="ehr_access")
    private ObjectRef<? extends ObjectId> ehrAccess;
    @Nullable
    private List<ObjectRef<? extends ObjectId>> compositions = new ArrayList<ObjectRef<? extends ObjectId>>();
    @Nullable
    private ObjectRef<? extends ObjectId> directory;
    @Nullable
    private List<ObjectRef<? extends ObjectId>> folders = new ArrayList<ObjectRef<? extends ObjectId>>();
    @XmlElement(name="time_created")
    private DvDateTime timeCreated;

    public Ehr() {
    }

    public Ehr(HierObjectId systemId, HierObjectId ehrId, DvDateTime timeCreated, List<ObjectRef<? extends ObjectId>> contributions, ObjectRef<? extends ObjectId> ehrStatus, ObjectRef<? extends ObjectId> ehrAccess, @Nullable ObjectRef<? extends ObjectId> directory, @Nullable List<ObjectRef<? extends ObjectId>> compositions) {
        this.systemId = systemId;
        this.ehrId = ehrId;
        this.contributions = contributions;
        this.ehrStatus = ehrStatus;
        this.ehrAccess = ehrAccess;
        this.compositions = compositions;
        this.directory = directory;
        this.timeCreated = timeCreated;
    }

    public HierObjectId getSystemId() {
        return this.systemId;
    }

    public void setSystemId(HierObjectId systemId) {
        this.systemId = systemId;
    }

    public HierObjectId getEhrId() {
        return this.ehrId;
    }

    public void setEhrId(HierObjectId ehrId) {
        this.ehrId = ehrId;
    }

    @Nullable
    public List<ObjectRef<? extends ObjectId>> getContributions() {
        return this.contributions;
    }

    public void setContributions(@Nullable List<ObjectRef<? extends ObjectId>> contributions) {
        this.contributions = contributions;
    }

    public void addContribution(ObjectRef<? extends ObjectId> contribution) {
        this.contributions.add(contribution);
    }

    public ObjectRef<? extends ObjectId> getEhrStatus() {
        return this.ehrStatus;
    }

    public void setEhrStatus(ObjectRef<? extends ObjectId> ehrStatus) {
        this.ehrStatus = ehrStatus;
    }

    public ObjectRef<? extends ObjectId> getEhrAccess() {
        return this.ehrAccess;
    }

    public void setEhrAccess(ObjectRef<? extends ObjectId> ehrAccess) {
        this.ehrAccess = ehrAccess;
    }

    @Nullable
    public List<ObjectRef<? extends ObjectId>> getCompositions() {
        return this.compositions;
    }

    public void setCompositions(@Nullable List<ObjectRef<? extends ObjectId>> compositions) {
        this.compositions = compositions;
    }

    public void addComposition(ObjectRef<? extends ObjectId> composition) {
        this.compositions.add(composition);
    }

    @Nullable
    public ObjectRef<? extends ObjectId> getDirectory() {
        return this.directory;
    }

    public void setDirectory(@Nullable ObjectRef<? extends ObjectId> directory) {
        this.directory = directory;
    }

    public DvDateTime getTimeCreated() {
        return this.timeCreated;
    }

    public void setTimeCreated(DvDateTime timeCreated) {
        this.timeCreated = timeCreated;
    }

    @Nullable
    public List<ObjectRef<? extends ObjectId>> getFolders() {
        return this.folders;
    }

    public void setFolders(@Nullable List<ObjectRef<? extends ObjectId>> folders) {
        this.folders = folders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ehr ehr = (Ehr)o;
        return Objects.equals(this.systemId, ehr.systemId) && Objects.equals(this.ehrId, ehr.ehrId) && Objects.equals(this.contributions, ehr.contributions) && Objects.equals(this.ehrStatus, ehr.ehrStatus) && Objects.equals(this.ehrAccess, ehr.ehrAccess) && Objects.equals(this.compositions, ehr.compositions) && Objects.equals(this.directory, ehr.directory) && Objects.equals(this.timeCreated, ehr.timeCreated) && Objects.equals(this.folders, ehr.folders);
    }

    public int hashCode() {
        return Objects.hash(this.systemId, this.ehrId, this.contributions, this.ehrStatus, this.ehrAccess, this.compositions, this.directory, this.timeCreated, this.folders);
    }

    @Invariant(value="Contributions valid")
    public boolean contributionsValid() {
        return InvariantUtil.objectRefTypeEquals(this.contributions, "CONTRIBUTION");
    }

    @Invariant(value="Ehr_access_valid")
    public boolean ehrAccessValid() {
        return InvariantUtil.objectRefTypeEquals(this.ehrAccess, "VERSIONED_EHR_ACCESS");
    }

    @Invariant(value="Ehr_status_valid")
    public boolean ehrStatusValid() {
        return InvariantUtil.objectRefTypeEquals(this.ehrStatus, "VERSIONED_EHR_STATUS");
    }

    @Invariant(value="Compositions_valid")
    public boolean compositionsValid() {
        return InvariantUtil.objectRefTypeEquals(this.compositions, "VERSIONED_COMPOSITION");
    }

    @Invariant(value="Directory_valid")
    public boolean directoryValid() {
        return InvariantUtil.objectRefTypeEquals(this.directory, "VERSIONED_FOLDER");
    }

    @Invariant(value="Folderss_valid")
    public boolean foldersValid() {
        return InvariantUtil.objectRefTypeEquals(this.folders, "VERSIONED_FOLDER");
    }

    @Invariant(value="Directory_in_folders")
    public boolean directoryInFolders() {
        if (this.folders != null && this.directory != null) {
            return this.folders.size() >= 1 && this.folders.get(0).equals(this.directory);
        }
        return true;
    }
}

