/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.generic;

import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvEHRURI;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.encapsulated.DvMultimedia;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rminfo.RMProperty;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ATTESTATION")
public class Attestation
extends AuditDetails {
    @Nullable
    @XmlElement(name="attested_view")
    private DvMultimedia attestedView;
    @Nullable
    private String proof;
    @Nullable
    private List<DvEHRURI> items = new ArrayList<DvEHRURI>();
    private DvText reason;
    @XmlElement(name="is_pending")
    @RMProperty(value="is_pending")
    private boolean isPending;

    public Attestation() {
    }

    public Attestation(String systemId, PartyProxy committer, DvDateTime timeCommitted, DvCodedText changeType, @Nullable DvText description, @Nullable DvMultimedia attestedView, @Nullable String proof, @Nullable List<DvEHRURI> items, DvText reason, boolean isPending) {
        super(systemId, committer, timeCommitted, changeType, description);
        this.attestedView = attestedView;
        this.proof = proof;
        this.items = items;
        this.reason = reason;
        this.isPending = isPending;
    }

    @Nullable
    public DvMultimedia getAttestedView() {
        return this.attestedView;
    }

    public void setAttestedView(@Nullable DvMultimedia attestedView) {
        this.attestedView = attestedView;
    }

    @Nullable
    public String getProof() {
        return this.proof;
    }

    public void setProof(@Nullable String proof) {
        this.proof = proof;
    }

    @Nullable
    public List<DvEHRURI> getItems() {
        return this.items;
    }

    public void setItems(@Nullable List<DvEHRURI> items) {
        this.items = items;
    }

    public DvText getReason() {
        return this.reason;
    }

    public void setReason(DvText reason) {
        this.reason = reason;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public void setPending(boolean pending) {
        this.isPending = pending;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Attestation that = (Attestation)o;
        return this.isPending == that.isPending && Objects.equals(this.attestedView, that.attestedView) && Objects.equals(this.proof, that.proof) && Objects.equals(this.items, that.items) && Objects.equals(this.reason, that.reason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.attestedView, this.proof, this.items, this.reason, this.isPending);
    }

    @Invariant(value="Items_valid", ignored=true)
    public boolean itemsValid() {
        return InvariantUtil.nullOrNotEmpty(this.items);
    }

    @Invariant(value="Reason_valid", ignored=true)
    public boolean reasonValid() {
        if (this.reason instanceof DvCodedText) {
            return InvariantUtil.belongsToTerminologyByGroupId((DvCodedText)this.reason, "attestation reason");
        }
        return true;
    }
}

