/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.generic;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PARTICIPATION", propOrder={"function", "mode", "time", "performer"})
public class Participation
extends RMObject {
    private DvText function;
    @Nullable
    private DvCodedText mode;
    @Nullable
    private DvInterval<DvDateTime> time;
    private PartyProxy performer;

    public Participation() {
    }

    public Participation(PartyProxy performer, DvText function, @Nullable DvCodedText mode, @Nullable DvInterval<DvDateTime> time) {
        this.function = function;
        this.mode = mode;
        this.time = time;
        this.performer = performer;
    }

    public DvText getFunction() {
        return this.function;
    }

    public void setFunction(DvText function) {
        this.function = function;
    }

    @Nullable
    public DvCodedText getMode() {
        return this.mode;
    }

    public void setMode(@Nullable DvCodedText mode) {
        this.mode = mode;
    }

    @Nullable
    public DvInterval<DvDateTime> getTime() {
        return this.time;
    }

    public void setTime(@Nullable DvInterval<DvDateTime> time) {
        this.time = time;
    }

    public PartyProxy getPerformer() {
        return this.performer;
    }

    public void setPerformer(PartyProxy performer) {
        this.performer = performer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participation that = (Participation)o;
        return Objects.equals(this.function, that.function) && Objects.equals(this.mode, that.mode) && Objects.equals(this.time, that.time) && Objects.equals(this.performer, that.performer);
    }

    public int hashCode() {
        return Objects.hash(this.function, this.mode, this.time, this.performer);
    }

    @Invariant(value="Function_valid")
    public boolean functionValid() {
        if (this.function instanceof DvCodedText) {
            return InvariantUtil.belongsToTerminologyByGroupId((DvCodedText)this.function, "participation function");
        }
        return true;
    }

    @Invariant(value="Mode_valid")
    public boolean modeValid() {
        return InvariantUtil.belongsToTerminologyByGroupId(this.mode, "participation mode");
    }
}

