/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.generic;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.PartyRef;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PARTY_IDENTIFIED", propOrder={"name", "identifiers"})
public class PartyIdentified
extends PartyProxy {
    @Nullable
    private String name;
    @Nullable
    private List<DvIdentifier> identifiers = new ArrayList<DvIdentifier>();

    public PartyIdentified() {
    }

    public PartyIdentified(@Nullable PartyRef externalRef, @Nullable String name, @Nullable List<DvIdentifier> identifiers) {
        super(externalRef);
        this.name = name;
        this.identifiers = identifiers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<DvIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<DvIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    public void addIdentifier(DvIdentifier identifier) {
        this.identifiers.add(identifier);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PartyIdentified that = (PartyIdentified)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.identifiers, that.identifiers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.identifiers);
    }

    @Invariant(value="Basic_validity")
    public boolean basicValidity() {
        return this.name != null || this.identifiers != null && !this.identifiers.isEmpty() || this.getExternalRef() != null;
    }

    @Invariant(value="Name_valid")
    public boolean nameValid() {
        return InvariantUtil.nullOrNotEmpty(this.name);
    }

    @Invariant(value="Identifiers_valid", ignored=true)
    public boolean identifiersValid() {
        return InvariantUtil.nullOrNotEmpty(this.identifiers);
    }
}

