/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.support.identification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.rm.support.identification.UID;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rm.support.identification.UUID;
import com.nedap.archie.rm.support.identification.VersionTreeId;
import com.nedap.archie.rminfo.RMProperty;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OBJECT_VERSION_ID")
public class ObjectVersionId
extends UIDBasedId {
    public ObjectVersionId() {
    }

    public ObjectVersionId(String value) {
        super(value);
    }

    public ObjectVersionId(String objectId, String creatingSystemId, String versionTreeId) {
        this(objectId + "::" + creatingSystemId + "::" + versionTreeId);
    }

    @JsonIgnore
    @XmlTransient
    public UID getObjectId() {
        return this.getRoot();
    }

    @JsonIgnore
    @XmlTransient
    public UID getCreatingSystemId() {
        if (this.getExtension() == null) {
            throw new UnsupportedOperationException("Invalid OBJECT_VERSION_ID. Needs to have EXTENSION.");
        }
        int index = this.getExtension().indexOf("::");
        if (index == -1) {
            throw new UnsupportedOperationException("Invalid OBJECT_VERSION_ID. Needs to have CREATING_SYSTEM_ID.");
        }
        String system = this.getExtension().substring(0, index);
        return new UUID(system);
    }

    @JsonIgnore
    @XmlTransient
    public VersionTreeId getVersionTreeId() {
        if (this.getExtension() == null) {
            throw new UnsupportedOperationException("Invalid OBJECT_VERSION_ID. Needs to have EXTENSION.");
        }
        int index = this.getExtension().indexOf("::");
        if (index == -1) {
            throw new UnsupportedOperationException("Invalid OBJECT_VERSION_ID. Needs to have CREATING_SYSTEM_ID.");
        }
        String version = this.getExtension().substring(index + 2);
        return new VersionTreeId(version);
    }

    @JsonIgnore
    @XmlTransient
    @RMProperty(value="is_branch")
    public boolean isBranch() {
        return this.getVersionTreeId().isBranch();
    }
}

