/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.support.identification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import com.nedap.archie.rm.support.identification.InternetId;
import com.nedap.archie.rm.support.identification.IsoOID;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.UID;
import com.nedap.archie.rm.support.identification.UUID;
import com.nedap.archie.rminfo.Invariant;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="UID_BASED_ID")
public abstract class UIDBasedId
extends ObjectId {
    public static final String UUID_REGEXP = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";

    public UIDBasedId() {
    }

    public UIDBasedId(String value) {
        super(value);
    }

    @JsonIgnore
    @XmlTransient
    public UID getRoot() {
        String value = this.getValue();
        if (value == null) {
            return null;
        }
        int index = value.indexOf("::");
        String resultString = null;
        resultString = index < 0 ? value : value.substring(0, index);
        if (resultString.matches(UUID_REGEXP)) {
            UUID result = new UUID();
            result.setValue(resultString);
            return result;
        }
        if (resultString.matches("([0-9]\\.?)+")) {
            IsoOID result = new IsoOID();
            result.setValue(resultString);
            return result;
        }
        InternetId result = new InternetId();
        result.setValue(resultString);
        return result;
    }

    @Nullable
    @JsonIgnore
    @XmlTransient
    public String getExtension() {
        String value = this.getValue();
        if (value == null) {
            return null;
        }
        int index = value.indexOf("::");
        if (index < 0) {
            return "";
        }
        return value.substring(index + 2);
    }

    @JsonIgnore
    public boolean hasExtension() {
        return !Strings.isNullOrEmpty((String)this.getExtension());
    }

    @Invariant(value="Has_extension_valid", ignored=true)
    public boolean hasExtensionValid() {
        return Strings.isNullOrEmpty((String)this.getExtension()) ^ this.hasExtension();
    }
}

