/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.support.identification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rminfo.RMProperty;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlTransient;

public class VersionTreeId
extends RMObject {
    public static final Pattern BRANCH_VERSION = Pattern.compile("[1-9][0-9]*[.][0-9]+[.][0-9]+");
    public static final Pattern SIMPLE_VERSION = Pattern.compile("[1-9][0-9]*");
    private String value;

    public VersionTreeId() {
    }

    public VersionTreeId(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @JsonIgnore
    @XmlTransient
    @RMProperty(value="is_branch")
    public boolean isBranch() {
        if (this.value == null) {
            return false;
        }
        if (BRANCH_VERSION.matcher(this.value).matches()) {
            return true;
        }
        if (SIMPLE_VERSION.matcher(this.value).matches()) {
            return false;
        }
        throw new IllegalArgumentException("Invalid object. Version needs to be 1- or 3-part numeric identifier.");
    }

    @JsonIgnore
    @XmlTransient
    public String getTrunkVersion() {
        if (this.value == null) {
            return null;
        }
        if (this.isBranch()) {
            int dot = this.value.indexOf(".");
            return this.value.substring(0, dot);
        }
        return this.value;
    }

    @JsonIgnore
    @XmlTransient
    public String getBranchNumber() {
        if (!this.isBranch()) {
            return null;
        }
        String branch = this.value.substring(this.value.indexOf(".") + 1);
        return branch.substring(0, branch.indexOf("."));
    }

    @JsonIgnore
    @XmlTransient
    public String getBranchVersion() {
        if (!this.isBranch()) {
            return null;
        }
        String branch = this.value.substring(this.value.indexOf(".") + 1);
        return branch.substring(branch.indexOf(".") + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionTreeId that = (VersionTreeId)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Invariant(value="Value_valid")
    public boolean valueValid() {
        return !Strings.isNullOrEmpty((String)this.value);
    }

    @Invariant(value="Value_format_valid")
    public boolean trunkVersionValid() {
        return Strings.isNullOrEmpty((String)this.value) || SIMPLE_VERSION.matcher(this.value).matches() || BRANCH_VERSION.matcher(this.value).matches();
    }
}

