/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.AuthoredResource;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.TranslationDetails;
import com.nedap.archie.aom.primitives.CBoolean;
import com.nedap.archie.aom.primitives.CDate;
import com.nedap.archie.aom.primitives.CDateTime;
import com.nedap.archie.aom.primitives.CDuration;
import com.nedap.archie.aom.primitives.CInteger;
import com.nedap.archie.aom.primitives.CReal;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.primitives.CTime;
import com.nedap.archie.base.Interval;
import com.nedap.archie.base.terminology.TerminologyCode;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.FeederAuditDetails;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.changecontrol.Contribution;
import com.nedap.archie.rm.changecontrol.ImportedVersion;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.changecontrol.Version;
import com.nedap.archie.rm.changecontrol.VersionedObject;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.Activity;
import com.nedap.archie.rm.composition.AdminEntry;
import com.nedap.archie.rm.composition.CareEntry;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.ContentItem;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.composition.Evaluation;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.InstructionDetails;
import com.nedap.archie.rm.composition.IsmTransition;
import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.composition.Section;
import com.nedap.archie.rm.datastructures.Cluster;
import com.nedap.archie.rm.datastructures.DataStructure;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datastructures.IntervalEvent;
import com.nedap.archie.rm.datastructures.Item;
import com.nedap.archie.rm.datastructures.ItemList;
import com.nedap.archie.rm.datastructures.ItemSingle;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datastructures.ItemTable;
import com.nedap.archie.rm.datastructures.ItemTree;
import com.nedap.archie.rm.datastructures.PointEvent;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DataValue;
import com.nedap.archie.rm.datavalues.DvBoolean;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvEHRURI;
import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.datavalues.DvParagraph;
import com.nedap.archie.rm.datavalues.DvState;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.DvURI;
import com.nedap.archie.rm.datavalues.TermMapping;
import com.nedap.archie.rm.datavalues.encapsulated.DvEncapsulated;
import com.nedap.archie.rm.datavalues.encapsulated.DvMultimedia;
import com.nedap.archie.rm.datavalues.encapsulated.DvParsable;
import com.nedap.archie.rm.datavalues.quantity.DvAbsoluteQuantity;
import com.nedap.archie.rm.datavalues.quantity.DvAmount;
import com.nedap.archie.rm.datavalues.quantity.DvCount;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.DvOrdered;
import com.nedap.archie.rm.datavalues.quantity.DvOrdinal;
import com.nedap.archie.rm.datavalues.quantity.DvProportion;
import com.nedap.archie.rm.datavalues.quantity.DvQuantified;
import com.nedap.archie.rm.datavalues.quantity.DvQuantity;
import com.nedap.archie.rm.datavalues.quantity.DvScale;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDate;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTemporal;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTime;
import com.nedap.archie.rm.datavalues.timespecification.DvGeneralTimeSpecification;
import com.nedap.archie.rm.datavalues.timespecification.DvPeriodicTimeSpecification;
import com.nedap.archie.rm.datavalues.timespecification.DvTimeSpecification;
import com.nedap.archie.rm.demographic.Actor;
import com.nedap.archie.rm.demographic.Address;
import com.nedap.archie.rm.demographic.Agent;
import com.nedap.archie.rm.demographic.Capability;
import com.nedap.archie.rm.demographic.Contact;
import com.nedap.archie.rm.demographic.Group;
import com.nedap.archie.rm.demographic.Organisation;
import com.nedap.archie.rm.demographic.Party;
import com.nedap.archie.rm.demographic.PartyIdentity;
import com.nedap.archie.rm.demographic.PartyRelationship;
import com.nedap.archie.rm.demographic.Person;
import com.nedap.archie.rm.demographic.Role;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.directory.VersionedFolder;
import com.nedap.archie.rm.ehr.Ehr;
import com.nedap.archie.rm.ehr.EhrAccess;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.ehr.VersionedEhrAccess;
import com.nedap.archie.rm.ehr.VersionedEhrStatus;
import com.nedap.archie.rm.generic.Attestation;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import com.nedap.archie.rm.integration.GenericEntry;
import com.nedap.archie.rm.security.AccessControlSettings;
import com.nedap.archie.rm.support.identification.AccessGroupRef;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.InternetId;
import com.nedap.archie.rm.support.identification.IsoOID;
import com.nedap.archie.rm.support.identification.LocatableRef;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.PartyRef;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rm.support.identification.UID;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rm.support.identification.UUID;
import com.nedap.archie.rm.support.identification.VersionTreeId;
import com.nedap.archie.rminfo.ArchieModelNamingStrategy;
import com.nedap.archie.rminfo.ModelNamingStrategy;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMPackageId;
import com.nedap.archie.rminfo.ReflectionModelInfoLookup;
import com.nedap.archie.rminfo.UpdatedValueHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ArchieRMInfoLookup
extends ReflectionModelInfoLookup {
    public static final String RM_VERSION = "1.1.0";
    private static ArchieRMInfoLookup instance;

    private ArchieRMInfoLookup() {
        super((ModelNamingStrategy)new ArchieModelNamingStrategy(), RMObject.class);
    }

    protected void addTypes(Class<?> baseClass) {
        this.addClass(Interval.class);
        this.addClass(AuditDetails.class);
        this.addClass(Ehr.class);
        this.addClass(DvTime.class);
        this.addClass(RevisionHistoryItem.class);
        this.addClass(PartyIdentity.class);
        this.addClass(DvParsable.class);
        this.addClass(DvDuration.class);
        this.addClass(DvDateTime.class);
        this.addClass(DvCount.class);
        this.addClass(Cluster.class);
        this.addClass(IsoOID.class);
        this.addClass(PartyRelated.class);
        this.addClass(Instruction.class);
        this.addClass(Person.class);
        this.addClass(GenericId.class);
        this.addClass(Evaluation.class);
        this.addClass(DvAmount.class);
        this.addClass(Capability.class);
        this.addClass(UID.class);
        this.addClass(Item.class);
        this.addClass(Contribution.class);
        this.addClass(OriginalVersion.class);
        this.addClass(FeederAuditDetails.class);
        this.addClass(PartyProxy.class);
        this.addClass(PointEvent.class);
        this.addClass(CodePhrase.class);
        this.addClass(InstructionDetails.class);
        this.addClass(DvTimeSpecification.class);
        this.addClass(DvAbsoluteQuantity.class);
        this.addClass(FeederAudit.class);
        this.addClass(Party.class);
        this.addClass(ItemSingle.class);
        this.addClass(EventContext.class);
        this.addClass(DvProportion.class);
        this.addClass(DvQuantity.class);
        this.addClass(DvOrdered.class);
        this.addClass(ContentItem.class);
        this.addClass(DataValue.class);
        this.addClass(DvOrdinal.class);
        this.addClass(DvScale.class);
        this.addClass(Agent.class);
        this.addClass(InternetId.class);
        this.addClass(Role.class);
        this.addClass(Group.class);
        this.addClass(ObjectId.class);
        this.addClass(UIDBasedId.class);
        this.addClass(VersionedEhrStatus.class);
        this.addClass(PartySelf.class);
        this.addClass(DvMultimedia.class);
        this.addClass(Actor.class);
        this.addClass(VersionTreeId.class);
        this.addClass(DvParagraph.class);
        this.addClass(ReferenceRange.class);
        this.addClass(CareEntry.class);
        this.addClass(ItemTree.class);
        this.addClass(Element.class);
        this.addClass(DvGeneralTimeSpecification.class);
        this.addClass(DvDate.class);
        this.addClass(Version.class);
        this.addClass(DvState.class);
        this.addClass(AccessControlSettings.class);
        this.addClass(ItemList.class);
        this.addClass(DataStructure.class);
        this.addClass(History.class);
        this.addClass(DvPeriodicTimeSpecification.class);
        this.addClass(Contact.class);
        this.addClass(TermMapping.class);
        this.addClass(Event.class);
        this.addClass(Observation.class);
        this.addClass(Locatable.class);
        this.addClass(UUID.class);
        this.addClass(DvTemporal.class);
        this.addClass(IsmTransition.class);
        this.addClass(Folder.class);
        this.addClass(Participation.class);
        this.addClass(VersionedComposition.class);
        this.addClass(ObjectVersionId.class);
        this.addClass(Entry.class);
        this.addClass(DvInterval.class);
        this.addClass(Organisation.class);
        this.addClass(VersionedObject.class);
        this.addClass(DvEncapsulated.class);
        this.addClass(VersionedFolder.class);
        this.addClass(IntervalEvent.class);
        this.addClass(ItemTable.class);
        this.addClass(Attestation.class);
        this.addClass(Address.class);
        this.addClass(RevisionHistory.class);
        this.addClass(DvIdentifier.class);
        this.addClass(DvCodedText.class);
        this.addClass(PartyRelationship.class);
        this.addClass(LocatableRef.class);
        this.addClass(Pathable.class);
        this.addClass(EhrAccess.class);
        this.addClass(DvEHRURI.class);
        this.addClass(ArchetypeID.class);
        this.addClass(RMObject.class);
        this.addClass(PartyRef.class);
        this.addClass(TemplateId.class);
        this.addClass(AdminEntry.class);
        this.addClass(VersionedEhrAccess.class);
        this.addClass(PartyIdentified.class);
        this.addClass(Composition.class);
        this.addClass(EhrStatus.class);
        this.addClass(AccessGroupRef.class);
        this.addClass(ObjectRef.class);
        this.addClass(GenericEntry.class);
        this.addClass(DvQuantified.class);
        this.addClass(ImportedVersion.class);
        this.addClass(DvBoolean.class);
        this.addClass(DvURI.class);
        this.addClass(DvText.class);
        this.addClass(Action.class);
        this.addClass(ItemStructure.class);
        this.addClass(HierObjectId.class);
        this.addClass(Section.class);
        this.addClass(Activity.class);
        this.addClass(TerminologyId.class);
        this.addClass(Link.class);
        this.addClass(Archetyped.class);
        this.addClass(AuthoredResource.class);
        this.addClass(TranslationDetails.class);
    }

    protected boolean isNullable(Class<?> clazz, Method getMethod, Field field) {
        if (field != null ? Party.class.isAssignableFrom(clazz) && field.getName().equalsIgnoreCase("uid") : getMethod != null && Party.class.isAssignableFrom(clazz) && getMethod.getName().equalsIgnoreCase("getUid")) {
            return false;
        }
        return super.isNullable(clazz, getMethod, field);
    }

    public static ArchieRMInfoLookup getInstance() {
        if (instance == null) {
            instance = new ArchieRMInfoLookup();
        }
        return instance;
    }

    public Class<?> getClassToBeCreated(String rmTypename) {
        if (rmTypename.equals("EVENT")) {
            return PointEvent.class;
        }
        return this.getClass(rmTypename);
    }

    public Object convertToConstraintObject(Object object, CPrimitiveObject<?, ?> cPrimitiveObject) {
        if (cPrimitiveObject instanceof CTerminologyCode) {
            if (object instanceof DvCodedText && ((DvCodedText)object).getDefiningCode() != null) {
                return this.convertCodePhrase(((DvCodedText)object).getDefiningCode());
            }
            if (object instanceof CodePhrase) {
                return this.convertCodePhrase((CodePhrase)object);
            }
            return new TerminologyCode();
        }
        return object;
    }

    private TerminologyCode convertCodePhrase(CodePhrase codePhrase) {
        TerminologyCode result = new TerminologyCode();
        result.setCodeString(codePhrase.getCodeString());
        result.setTerminologyId(codePhrase.getTerminologyId() == null ? null : codePhrase.getTerminologyId().getValue());
        return result;
    }

    public Object convertConstrainedPrimitiveToRMObject(Object object) {
        if (object instanceof TerminologyCode) {
            return this.convertTerminologyCode((TerminologyCode)object);
        }
        return object;
    }

    private CodePhrase convertTerminologyCode(TerminologyCode terminologyCode) {
        CodePhrase result = new CodePhrase();
        result.setCodeString(terminologyCode.getCodeString());
        result.setTerminologyId(terminologyCode == null ? null : new TerminologyId(terminologyCode.getTerminologyId()));
        return result;
    }

    public void processCreatedObject(Object createdObject, CObject constraint) {
        if (createdObject instanceof Locatable) {
            CArchetypeRoot root;
            Locatable locatable = (Locatable)createdObject;
            locatable.setArchetypeNodeId(constraint.getNodeId());
            locatable.setNameAsString(constraint.getMeaning());
            if (constraint instanceof CArchetypeRoot && (root = (CArchetypeRoot)constraint).getArchetypeRef() != null) {
                Archetyped details = new Archetyped();
                details.setArchetypeId(new ArchetypeID(root.getArchetypeRef()));
                details.setRmVersion(RM_VERSION);
                locatable.setArchetypeDetails(details);
            }
        }
    }

    public String getArchetypeNodeIdFromRMObject(Object rmObject) {
        if (rmObject == null) {
            return null;
        }
        if (rmObject instanceof Locatable) {
            Locatable locatable = (Locatable)rmObject;
            return locatable.getArchetypeNodeId();
        }
        return null;
    }

    public String getArchetypeIdFromArchetypedRmObject(Object rmObject) {
        Locatable locatable;
        if (rmObject instanceof Locatable && (locatable = (Locatable)rmObject).getArchetypeDetails() != null) {
            return locatable.getArchetypeDetails().getArchetypeId().getFullId();
        }
        return null;
    }

    public String getNameFromRMObject(Object rmObject) {
        if (rmObject == null) {
            return null;
        }
        if (rmObject instanceof Locatable) {
            Locatable locatable = (Locatable)rmObject;
            return locatable.getNameAsString();
        }
        return null;
    }

    public Object clone(Object rmObject) {
        if (rmObject instanceof RMObject) {
            return ((RMObject)rmObject).clone();
        }
        throw new IllegalArgumentException("The ArchieRMInfoLookup can only clone openehr reference model objects");
    }

    public Map<String, Object> pathHasBeenUpdated(Object rmObject, Archetype archetype, String pathOfParent, Object parent) {
        return UpdatedValueHandler.pathHasBeenUpdated(rmObject, archetype, pathOfParent, parent);
    }

    public boolean validatePrimitiveType(String rmTypeName, String rmAttributeName, CPrimitiveObject<?, ?> cObject) {
        RMAttributeInfo attributeInfo = this.getAttributeInfo(rmTypeName, rmAttributeName);
        if (attributeInfo == null) {
            return true;
        }
        Class typeInCollection = attributeInfo.getTypeInCollection();
        if (cObject instanceof CInteger) {
            return typeInCollection.equals(Long.class) || typeInCollection.getName().equals("long");
        }
        if (cObject instanceof CReal) {
            return typeInCollection.equals(Double.class) || typeInCollection.getName().equals("double");
        }
        if (cObject instanceof CString) {
            return typeInCollection.equals(String.class);
        }
        if (cObject instanceof CDate) {
            return typeInCollection.equals(String.class) || typeInCollection.isAssignableFrom(Temporal.class);
        }
        if (cObject instanceof CDateTime) {
            return typeInCollection.equals(String.class) || typeInCollection.isAssignableFrom(Temporal.class);
        }
        if (cObject instanceof CDuration) {
            return typeInCollection.equals(String.class) || typeInCollection.isAssignableFrom(TemporalAccessor.class) || typeInCollection.isAssignableFrom(TemporalAmount.class);
        }
        if (cObject instanceof CTime) {
            return typeInCollection.equals(String.class) || typeInCollection.isAssignableFrom(TemporalAccessor.class);
        }
        if (cObject instanceof CTerminologyCode) {
            return typeInCollection.equals(CodePhrase.class) || typeInCollection.equals(DvCodedText.class);
        }
        if (cObject instanceof CBoolean) {
            return typeInCollection.equals(Boolean.class) || typeInCollection.getName().equals("boolean");
        }
        return false;
    }

    public Collection<RMPackageId> getId() {
        ArrayList<RMPackageId> result = new ArrayList<RMPackageId>();
        result.add(new RMPackageId("openEHR", "EHR"));
        result.add(new RMPackageId("openEHR", "DEMOGRAPHIC"));
        return result;
    }
}

