/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.nedap.archie.ArchieLanguageConfiguration;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.Interval;
import com.nedap.archie.query.APathQuery;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.quantity.DvOrdinal;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatedValueHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdatedValueHandler.class);

    public static Map<String, Object> pathHasBeenUpdated(Object rmObject, Archetype archetype, String pathOfParent, Object parent) {
        if (parent instanceof CodePhrase) {
            return UpdatedValueHandler.fixCodePhrase(rmObject, archetype, pathOfParent);
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> fixCodePhrase(Object rmObject, Archetype archetype, String pathOfParent) {
        try {
            if (pathOfParent.endsWith("value/defining_code") || pathOfParent.endsWith("null_flavour/defining_code")) {
                return UpdatedValueHandler.fixDvCodedText(rmObject, archetype, pathOfParent);
            }
            if (pathOfParent.endsWith("symbol/defining_code")) {
                return UpdatedValueHandler.fixDvOrdinal(rmObject, archetype, pathOfParent);
            }
        }
        catch (Exception e) {
            logger.warn("cannot fix codephrase", (Throwable)e);
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> fixDvOrdinal(Object rmObject, Archetype archetype, String pathOfParent) throws XPathExpressionException {
        CAttributeTuple socParent;
        HashMap<String, Object> result = new HashMap<String, Object>();
        RMPathQuery rmPathQuery = new RMPathQuery(pathOfParent.replace("/symbol/defining_code", ""));
        DvOrdinal ordinal = (DvOrdinal)rmPathQuery.find((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), rmObject);
        Long value = null;
        CAttribute symbolAttribute = (CAttribute)archetype.itemAtPath(pathOfParent.replace("/symbol/defining_code", "/symbol"));
        if (symbolAttribute != null && (socParent = (CAttributeTuple)symbolAttribute.getSocParent()) != null) {
            int valueIndex = socParent.getMemberIndex("value");
            int symbolIndex = socParent.getMemberIndex("symbol");
            if (valueIndex != -1 && symbolIndex != -1) {
                for (CPrimitiveTuple tuple : socParent.getTuples()) {
                    Interval interval;
                    List valueConstraint;
                    if (!((CPrimitiveObject)tuple.getMembers().get(symbolIndex)).getConstraint().get(0).equals(ordinal.getSymbol().getDefiningCode().getCodeString()) || (valueConstraint = ((CPrimitiveObject)tuple.getMembers().get(valueIndex)).getConstraint()).size() != 1 || !((Long)(interval = (Interval)valueConstraint.get(0)).getLower()).equals(interval.getUpper()) || interval.isLowerUnbounded() || interval.isUpperUnbounded()) continue;
                    value = (Long)interval.getLower();
                    ordinal.setValue(value);
                    String pathToValue = pathOfParent.replace("/symbol/defining_code", "/value");
                    result.put(pathToValue, value);
                }
            }
        }
        if (ordinal.getSymbol() != null && ordinal.getSymbol().getDefiningCode() != null) {
            result.putAll(UpdatedValueHandler.fixDvCodedText(rmObject, archetype, pathOfParent));
        }
        return result;
    }

    private static Map<String, Object> fixDvCodedText(Object rmObject, Archetype archetype, String pathOfParent) throws XPathExpressionException {
        ArchetypeTerm termDefinition;
        String path = pathOfParent.replace("/defining_code", "");
        RMPathQuery rmPathQuery = new RMPathQuery(path);
        DvCodedText codedText = (DvCodedText)rmPathQuery.find((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), rmObject);
        Archetyped details = UpdatedValueHandler.findLastArchetypeDetails(rmObject, pathOfParent);
        if (details != null && archetype instanceof OperationalTemplate) {
            OperationalTemplate template = (OperationalTemplate)archetype;
            termDefinition = UpdatedValueHandler.getTermDefinition(template, details, codedText);
        } else {
            termDefinition = archetype.getTerminology().getTermDefinition(ArchieLanguageConfiguration.getMeaningAndDescriptionLanguage(), codedText.getDefiningCode().getCodeString());
        }
        return UpdatedValueHandler.setDvCodedTextValue(codedText, termDefinition, path);
    }

    private static ArchetypeTerm getTermDefinition(OperationalTemplate template, Archetyped details, DvCodedText codedText) {
        ArchetypeTerm termDefinition;
        ArchetypeTerminology archetypeTerminology = (ArchetypeTerminology)template.getComponentTerminologies().get(details.getArchetypeId().toString());
        if (archetypeTerminology != null && (termDefinition = archetypeTerminology.getTermDefinition(ArchieLanguageConfiguration.getMeaningAndDescriptionLanguage(), codedText.getDefiningCode().getCodeString())) != null) {
            return termDefinition;
        }
        return template.getTerminology().getTermDefinition(ArchieLanguageConfiguration.getMeaningAndDescriptionLanguage(), codedText.getDefiningCode().getCodeString());
    }

    private static Map<String, Object> setDvCodedTextValue(DvCodedText codedText, ArchetypeTerm termDefinition, String path) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (termDefinition != null) {
            String value = termDefinition.getText();
            codedText.setValue(value);
            result.put(path + "/value", value);
        }
        if (codedText.getDefiningCode() != null && (codedText.getDefiningCode().getTerminologyId() == null || Strings.isNullOrEmpty((String)codedText.getDefiningCode().getTerminologyId().getValue())) && AOMUtils.isValueCode((String)codedText.getDefiningCode().getCodeString())) {
            codedText.getDefiningCode().setTerminologyId(new TerminologyId("local"));
            result.put(path + "/defining_code/terminology_id/value", "local");
        }
        return result;
    }

    public static Archetyped findLastArchetypeDetails(Object rmObject, String path) throws XPathExpressionException {
        APathQuery query = new APathQuery(path);
        for (int i = query.getPathSegments().size(); i > 0; --i) {
            String subpath = Joiner.on((String)"").join(query.getPathSegments().subList(0, i));
            List list = new RMPathQuery(subpath).findList((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), rmObject);
            for (RMObjectWithPath objectWithPath : list) {
                Locatable object1;
                Object object = objectWithPath.getObject();
                if (!(object instanceof Locatable) || (object1 = (Locatable)object).getArchetypeDetails() == null) continue;
                return object1.getArchetypeDetails();
            }
        }
        return null;
    }
}

