/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rmutil;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.terminology.OpenEHRTerminologyAccess;
import com.nedap.archie.terminology.TermCode;
import java.util.Collection;
import java.util.List;

public class InvariantUtil {
    public static final String ENGLISH = "en";

    public static boolean nullOrNotEmpty(Collection<?> collection) {
        if (collection != null) {
            return !collection.isEmpty();
        }
        return true;
    }

    public static boolean nullOrNotEmpty(String string) {
        if (string != null) {
            return !string.isEmpty();
        }
        return true;
    }

    public static boolean belongsToTerminologyByOpenEHRId(CodePhrase value, String openEHRId) {
        if (value != null && value.getCodeString() != null) {
            TermCode termCode = OpenEHRTerminologyAccess.getInstance().getTermByOpenEhrId(openEHRId, value.getCodeString(), ENGLISH);
            return termCode != null && termCode != null && (value.getTerminologyId() == null || value.getTerminologyId().getValue().equalsIgnoreCase(termCode.getTerminologyId()));
        }
        return true;
    }

    public static boolean belongsToTerminologyByGroupId(CodePhrase value, String groupId) {
        if (value != null && value.getCodeString() != null) {
            TermCode termCode = OpenEHRTerminologyAccess.getInstance().getTermByOpenEHRGroup(groupId, ENGLISH, value.getCodeString());
            return termCode != null && termCode != null && (value.getTerminologyId() == null || value.getTerminologyId().getValue().equalsIgnoreCase(termCode.getTerminologyId()));
        }
        return true;
    }

    public static boolean belongsToTerminologyByOpenEHRId(DvCodedText value, String openEHRId) {
        if (value != null) {
            return InvariantUtil.belongsToTerminologyByOpenEHRId(value.getDefiningCode(), openEHRId);
        }
        return true;
    }

    public static boolean belongsToTerminologyByGroupId(DvCodedText value, String groupId) {
        if (value != null) {
            return InvariantUtil.belongsToTerminologyByGroupId(value.getDefiningCode(), groupId);
        }
        return true;
    }

    public static boolean objectRefTypeEquals(List<ObjectRef<? extends ObjectId>> refs, String type) {
        if (refs == null) {
            return true;
        }
        for (ObjectRef<? extends ObjectId> ref : refs) {
            if (InvariantUtil.objectRefTypeEquals(ref, type)) continue;
            return false;
        }
        return true;
    }

    public static boolean objectRefTypeEquals(ObjectRef<?> ref, String type) {
        return ref == null || ref.getType() == null || ref.getType().equals(type);
    }
}

