/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.utils.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.openehr.utils.operation.OperationOutcome;
import org.openehr.utils.operation.OperationOutcomeStatus;

public class FileAndDirUtils {
    public static List<OperationOutcome<File>> loadDirectories(List<String> directories) {
        ArrayList<OperationOutcome<File>> loadedDirectories = new ArrayList<OperationOutcome<File>>();
        directories.forEach(directoryPath -> {
            File directory = new File((String)directoryPath);
            if (directory.exists() && directory.isDirectory()) {
                loadedDirectories.add(new OperationOutcome<File>(directory));
            } else {
                loadedDirectories.add(new OperationOutcome<Object>(null, OperationOutcomeStatus.FAILURE));
            }
        });
        return loadedDirectories;
    }

    public static List<File> filterFilesFromDirectories(List<File> directories, IOFileFilter fileFilter, boolean recursive) {
        ArrayList<File> loadedFiles = new ArrayList<File>();
        directories.forEach(dir -> loadedFiles.addAll(FileUtils.listFiles((File)dir, (IOFileFilter)fileFilter, null)));
        return loadedFiles;
    }

    public static List<File> loadFilesWithExtensionFromDirectoryPaths(List<File> directories, final String extension, boolean recursive) {
        IOFileFilter filter = new IOFileFilter(){

            public boolean accept(File file) {
                return file.getAbsolutePath().endsWith(extension);
            }

            public boolean accept(File file, String s) {
                return s.endsWith(extension);
            }
        };
        return FileAndDirUtils.filterFilesFromDirectories(directories, filter, recursive);
    }

    public static List<File> loadFilesWithExtensionFromDirectories(List<String> directoryPaths, String extension, boolean recursive) {
        ArrayList<File> directories = new ArrayList<File>();
        List<OperationOutcome<File>> loadedDirectories = FileAndDirUtils.loadDirectories(directoryPaths);
        for (OperationOutcome<File> dir : loadedDirectories) {
            if (dir.getStatus() != OperationOutcomeStatus.SUCCESS) continue;
            directories.add(dir.getResult());
        }
        return FileAndDirUtils.loadFilesWithExtensionFromDirectoryPaths(directories, extension, recursive);
    }

    public static void copyStreamToTargetFile(String sourceClassPath, String destinationFilePath) {
        InputStream is = FileAndDirUtils.class.getResourceAsStream(sourceClassPath);
        File destination = new File(destinationFilePath);
        try {
            FileUtils.copyInputStreamToFile((InputStream)is, (File)destination);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void copyFileToDirectory(String filePath, String dirPath) {
        File source = new File(filePath);
        File dest = new File(dirPath);
        try {
            FileUtils.copyFileToDirectory((File)source, (File)dest);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void copyFileToDirectory(File fileToCopy, String dirPath) {
        File dest = new File(dirPath);
        try {
            FileUtils.copyFileToDirectory((File)fileToCopy, (File)dest);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void copyFileToDirectory(File fileToCopy, File destination) {
        try {
            FileUtils.copyFileToDirectory((File)fileToCopy, (File)destination);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void copyDirectoryAndContent(String sourceDirPath, String destDirPath) {
        File source = new File(sourceDirPath);
        File dest = new File(destDirPath);
        try {
            FileUtils.copyDirectory((File)source, (File)dest);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static File getResourceAsFile(String resourcePath) {
        try {
            InputStream in = FileAndDirUtils.class.getResourceAsStream(resourcePath);
            if (in == null) {
                return null;
            }
            File tempFile = File.createTempFile(String.valueOf(resourcePath.hashCode()), ".tmp");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            return tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

