/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.Connection;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.ExecuteWithFailover;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.IsRetryableException;
import com.netflix.astyanax.connectionpool.exceptions.UnknownException;

public abstract class AbstractExecuteWithFailoverImpl<CL, R>
implements ExecuteWithFailover<CL, R> {
    protected Connection<CL> connection = null;
    private long startTime;
    private long poolStartTime;
    private int attemptCounter = 0;
    private final ConnectionPoolMonitor monitor;
    protected final ConnectionPoolConfiguration config;

    public AbstractExecuteWithFailoverImpl(ConnectionPoolConfiguration config, ConnectionPoolMonitor monitor) throws ConnectionException {
        this.monitor = monitor;
        this.config = config;
        this.startTime = this.poolStartTime = System.currentTimeMillis();
    }

    public final Host getCurrentHost() {
        HostConnectionPool<CL> pool = this.getCurrentHostConnectionPool();
        if (pool != null) {
            return pool.getHost();
        }
        return Host.NO_HOST;
    }

    public abstract HostConnectionPool<CL> getCurrentHostConnectionPool();

    public abstract Connection<CL> borrowConnection(Operation<CL, R> var1) throws ConnectionException;

    public abstract boolean canRetry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult<R> tryOperation(Operation<CL, R> operation) throws ConnectionException {
        Operation<CL, R> filteredOperation = this.config.getOperationFilterFactory().attachFilter(operation);
        while (true) {
            ++this.attemptCounter;
            try {
                this.connection = this.borrowConnection(filteredOperation);
                this.startTime = System.currentTimeMillis();
                OperationResult<R> result = this.connection.execute(filteredOperation);
                result.setAttemptsCount(this.attemptCounter);
                this.monitor.incOperationSuccess(this.getCurrentHost(), result.getLatency());
                OperationResult<R> operationResult = result;
                return operationResult;
            }
            catch (Exception e) {
                ConnectionException ce = e instanceof ConnectionException ? (ConnectionException)e : new UnknownException(e);
                try {
                    this.informException(ce);
                    this.monitor.incFailover(ce.getHost(), ce);
                    continue;
                }
                catch (ConnectionException ex) {
                    this.monitor.incOperationFailure(this.getCurrentHost(), ex);
                    throw ex;
                }
            }
            finally {
                this.releaseConnection();
                continue;
            }
            break;
        }
    }

    protected void releaseConnection() {
        if (this.connection != null) {
            this.connection.getHostConnectionPool().returnConnection(this.connection);
            this.connection = null;
        }
    }

    private void informException(ConnectionException connectionException) throws ConnectionException {
        connectionException.setHost(this.getCurrentHost()).setLatency(System.currentTimeMillis() - this.startTime).setAttempt(this.attemptCounter).setLatencyWithPool(System.currentTimeMillis() - this.poolStartTime);
        if (connectionException instanceof IsRetryableException) {
            if (!this.canRetry()) {
                throw connectionException;
            }
        } else {
            throw connectionException;
        }
    }
}

