/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.collect.Maps;
import com.netflix.astyanax.connectionpool.NodeDiscovery;
import com.netflix.astyanax.connectionpool.NodeDiscoveryMonitor;
import com.netflix.astyanax.connectionpool.NodeDiscoveryMonitorMBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class NodeDiscoveryMonitorManager {
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private HashMap<String, NodeDiscoveryMonitorMBean> monitors = Maps.newHashMap();

    private NodeDiscoveryMonitorManager() {
    }

    public static NodeDiscoveryMonitorManager getInstance() {
        return LazyHolder.instance;
    }

    public synchronized void registerMonitor(String monitorName, NodeDiscovery discovery) {
        if (!this.monitors.containsKey(monitorName = this.generateMonitorName(monitorName))) {
            try {
                ObjectName oName = new ObjectName(monitorName);
                NodeDiscoveryMonitor mbean = new NodeDiscoveryMonitor(discovery);
                this.monitors.put(monitorName, mbean);
                this.mbs.registerMBean(mbean, oName);
            }
            catch (Exception e) {
                this.monitors.remove(monitorName);
            }
        }
    }

    public synchronized void unregisterMonitor(String monitorName, NodeDiscovery discovery) {
        monitorName = this.generateMonitorName(monitorName);
        this.monitors.remove(monitorName);
        try {
            this.mbs.unregisterMBean(new ObjectName(monitorName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized NodeDiscoveryMonitorMBean getCassandraMonitor(String monitorName) {
        monitorName = this.generateMonitorName(monitorName);
        return this.monitors.get(monitorName);
    }

    private String generateMonitorName(String monitorName) {
        StringBuilder sb = new StringBuilder();
        sb.append("com.netflix.MonitoredResources");
        sb.append(":type=ASTYANAX");
        sb.append(",name=" + monitorName.toString());
        sb.append(",ServiceType=discovery");
        return sb.toString();
    }

    private static class LazyHolder {
        private static final NodeDiscoveryMonitorManager instance = new NodeDiscoveryMonitorManager();

        private LazyHolder() {
        }
    }
}

