/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.RateLimiter;
import java.util.concurrent.LinkedBlockingDeque;

public class SimpleRateLimiterImpl
implements RateLimiter {
    private final LinkedBlockingDeque<Long> queue = new LinkedBlockingDeque();
    private final ConnectionPoolConfiguration config;

    public SimpleRateLimiterImpl(ConnectionPoolConfiguration config) {
        this.config = config;
    }

    @Override
    public boolean check() {
        return this.check(System.currentTimeMillis());
    }

    @Override
    public boolean check(long currentTimeMillis) {
        int maxCount = this.config.getConnectionLimiterMaxPendingCount();
        if (maxCount == 0) {
            return true;
        }
        if (this.queue.size() < maxCount) {
            this.queue.addFirst(currentTimeMillis);
            return true;
        }
        long last = this.queue.getLast();
        if (currentTimeMillis - last < (long)this.config.getConnectionLimiterWindowSize()) {
            return false;
        }
        this.queue.addFirst(currentTimeMillis);
        this.queue.removeLast();
        return true;
    }
}

