/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import java.math.BigInteger;

public class TokenGenerator {
    public static final BigInteger MINIMUM = new BigInteger("0");
    public static final BigInteger MAXIMUM = new BigInteger("2").pow(127);

    public static String initialToken(int size, int position) {
        return TokenGenerator.initialToken(size, position, MINIMUM, MAXIMUM);
    }

    public static String initialToken(int size, int position, BigInteger minInitialToken, BigInteger maxInitialToken) {
        BigInteger decValue = minInitialToken;
        if (position != 0) {
            decValue = maxInitialToken.multiply(new BigInteger("" + position)).divide(new BigInteger("" + size));
        }
        return decValue.toString();
    }

    public static String tokenMinusOne(String payload) {
        BigInteger bigInt = new BigInteger(payload);
        if (bigInt.equals(MINIMUM)) {
            bigInt = MAXIMUM;
        }
        bigInt = bigInt.subtract(new BigInteger("1"));
        return bigInt.toString();
    }

    public static BigInteger tokenDifference(BigInteger startToken, BigInteger endToken) {
        if (startToken.compareTo(endToken) < 0) {
            return endToken.subtract(startToken);
        }
        return endToken.add(MAXIMUM).subtract(startToken);
    }

    public static BigInteger tokenDifference(String startToken, String endToken) {
        return TokenGenerator.tokenDifference(new BigInteger(startToken), new BigInteger(endToken));
    }

    public static String getMaximumToken() {
        return MAXIMUM.toString();
    }

    public static String getMinimumToken() {
        return MINIMUM.toString();
    }
}

