/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.transport;

import com.netflix.discovery.shared.dns.DnsService;
import com.netflix.discovery.shared.dns.DnsServiceImpl;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.decorator.MetricsCollectingEurekaHttpClient;
import com.netflix.discovery.shared.transport.decorator.RedirectingEurekaHttpClient;
import com.netflix.discovery.shared.transport.decorator.RetryableEurekaHttpClient;
import com.netflix.discovery.shared.transport.decorator.ServerStatusEvaluator;
import com.netflix.discovery.shared.transport.decorator.ServerStatusEvaluators;
import com.netflix.discovery.shared.transport.decorator.SessionedEurekaHttpClient;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.EurekaServerHttpClientFactory;
import com.netflix.eureka.transport.Jersey3RemoteRegionClientFactory;

public class Jersey3EurekaServerHttpClientFactory
implements EurekaServerHttpClientFactory {
    public static final long RECONNECT_INTERVAL_MINUTES = 30L;

    public EurekaHttpClient createRemoteRegionClient(EurekaServerConfig serverConfig, EurekaTransportConfig transportConfig, ServerCodecs serverCodecs, ClusterResolver<EurekaEndpoint> clusterResolver) {
        Jersey3RemoteRegionClientFactory jersey3RemoteRegionClientFactory = new Jersey3RemoteRegionClientFactory(serverConfig, serverCodecs, clusterResolver.getRegion());
        TransportClientFactory metricsFactory = MetricsCollectingEurekaHttpClient.createFactory((TransportClientFactory)jersey3RemoteRegionClientFactory);
        SessionedEurekaHttpClient client = new SessionedEurekaHttpClient("remote", RetryableEurekaHttpClient.createFactory((String)"remote", (EurekaTransportConfig)transportConfig, clusterResolver, (TransportClientFactory)Jersey3EurekaServerHttpClientFactory.createFactory(metricsFactory), (ServerStatusEvaluator)ServerStatusEvaluators.legacyEvaluator()), 1800000L);
        return client;
    }

    public static TransportClientFactory createFactory(final TransportClientFactory delegateFactory) {
        final DnsServiceImpl dnsService = new DnsServiceImpl();
        return new TransportClientFactory(){

            public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
                return new RedirectingEurekaHttpClient(endpoint.getServiceUrl(), delegateFactory, (DnsService)dnsService);
            }

            public void shutdown() {
                delegateFactory.shutdown();
            }
        };
    }
}

