/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixMetrics;
import com.netflix.hystrix.util.HystrixRollingNumber;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import com.netflix.hystrix.util.HystrixRollingPercentile;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixCollapserMetrics
extends HystrixMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HystrixCollapserMetrics.class);
    private static final ConcurrentHashMap<String, HystrixCollapserMetrics> metrics = new ConcurrentHashMap();
    private final HystrixCollapserKey key;
    private final HystrixCollapserProperties properties;
    private final HystrixRollingPercentile percentileBatchSize;
    private final HystrixRollingPercentile percentileShardSize;

    public static HystrixCollapserMetrics getInstance(HystrixCollapserKey key, HystrixCollapserProperties properties) {
        HystrixCollapserMetrics collapserMetrics = metrics.get(key.name());
        if (collapserMetrics != null) {
            return collapserMetrics;
        }
        collapserMetrics = new HystrixCollapserMetrics(key, properties);
        HystrixCollapserMetrics existing = metrics.putIfAbsent(key.name(), collapserMetrics);
        if (existing == null) {
            return collapserMetrics;
        }
        return existing;
    }

    public static Collection<HystrixCollapserMetrics> getInstances() {
        return Collections.unmodifiableCollection(metrics.values());
    }

    static void reset() {
        metrics.clear();
    }

    HystrixCollapserMetrics(HystrixCollapserKey key, HystrixCollapserProperties properties) {
        super(new HystrixRollingNumber(properties.metricsRollingStatisticalWindowInMilliseconds(), properties.metricsRollingStatisticalWindowBuckets()));
        this.key = key;
        this.properties = properties;
        this.percentileBatchSize = new HystrixRollingPercentile(properties.metricsRollingPercentileWindowInMilliseconds(), properties.metricsRollingPercentileWindowBuckets(), properties.metricsRollingPercentileBucketSize(), properties.metricsRollingPercentileEnabled());
        this.percentileShardSize = new HystrixRollingPercentile(properties.metricsRollingPercentileWindowInMilliseconds(), properties.metricsRollingPercentileWindowBuckets(), properties.metricsRollingPercentileBucketSize(), properties.metricsRollingPercentileEnabled());
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.key;
    }

    public HystrixCollapserProperties getProperties() {
        return this.properties;
    }

    public int getBatchSizePercentile(double percentile) {
        return this.percentileBatchSize.getPercentile(percentile);
    }

    public int getBatchSizeMean() {
        return this.percentileBatchSize.getMean();
    }

    public int getShardSizePercentile(double percentile) {
        return this.percentileShardSize.getPercentile(percentile);
    }

    public int getShardSizeMean() {
        return this.percentileShardSize.getMean();
    }

    public void markRequestBatched() {
        this.counter.increment(HystrixRollingNumberEvent.COLLAPSER_REQUEST_BATCHED);
    }

    public void markResponseFromCache() {
        this.counter.increment(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE);
    }

    public void markBatch(int batchSize) {
        this.percentileBatchSize.addValue(batchSize);
        this.counter.increment(HystrixRollingNumberEvent.COLLAPSER_BATCH);
    }

    public void markShards(int numShards) {
        this.percentileShardSize.addValue(numShards);
    }
}

