/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.serial;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialHystrixMetric {
    protected static final JsonFactory jsonFactory = new JsonFactory();
    protected static final CBORFactory cborFactory = new CBORFactory();
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected static final Logger logger = LoggerFactory.getLogger(SerialHystrixMetric.class);

    public static String fromByteBufferToString(ByteBuffer bb) {
        byte[] byteArray = new byte[bb.remaining()];
        bb.get(byteArray);
        try {
            CBORParser parser = cborFactory.createParser(byteArray);
            JsonNode rootNode = (JsonNode)mapper.readTree((JsonParser)parser);
            return rootNode.toString();
        }
        catch (IOException ioe) {
            logger.error("IO Exception during deserialization of ByteBuffer of Hystrix Metric : " + ioe);
            return "";
        }
    }
}

