/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.concurrent.atomic.AtomicLong;

public class ResettableCounter
extends AbstractMonitor<Long>
implements Counter,
ResettableMonitor<Long> {
    private final AtomicLong count = new AtomicLong(0L);

    public ResettableCounter(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
    }

    @Override
    public void increment() {
        this.count.incrementAndGet();
    }

    @Override
    public void increment(long amount) {
        this.count.getAndAdd(amount);
    }

    @Override
    public Long getValue() {
        return this.count.get();
    }

    @Override
    public Long getAndResetValue() {
        return this.count.getAndSet(0L);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ResettableCounter)) {
            return false;
        }
        ResettableCounter m = (ResettableCounter)obj;
        return this.config.equals(m.getConfig()) && this.count.get() == m.count.get();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.count.get()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("count", this.count.get()).toString();
    }
}

