/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.netflix.servo.tag.Tag;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum InjectableTag implements Tag
{
    HOSTNAME("hostname", InjectableTag.getHostName()),
    IP("ip", InjectableTag.getIp());

    private static final Logger LOGGER;
    private final String key;
    private final String value;

    private InjectableTag(String key, String val) {
        this.key = key;
        this.value = val;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String tagString() {
        return this.key + "=" + this.value;
    }

    private static String getHostName() {
        return InjectableTag.loadAddress() != null ? InjectableTag.loadAddress().getHostName() : "unkownHost";
    }

    private static String getIp() {
        return InjectableTag.loadAddress() != null ? InjectableTag.loadAddress().getHostAddress() : "unknownHost";
    }

    private static InetAddress loadAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to load INET info.", (Throwable)e);
            return null;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(InjectableTag.class);
    }
}

