/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl.matcher;

import com.netflix.spectator.impl.AsciiSet;
import com.netflix.spectator.impl.matcher.AnyMatcher;
import com.netflix.spectator.impl.matcher.CharClassMatcher;
import com.netflix.spectator.impl.matcher.CharSeqMatcher;
import com.netflix.spectator.impl.matcher.Constants;
import com.netflix.spectator.impl.matcher.EndMatcher;
import com.netflix.spectator.impl.matcher.Matcher;
import com.netflix.spectator.impl.matcher.NegativeLookaheadMatcher;
import com.netflix.spectator.impl.matcher.OrMatcher;
import com.netflix.spectator.impl.matcher.PatternUtils;
import com.netflix.spectator.impl.matcher.PositiveLookaheadMatcher;
import com.netflix.spectator.impl.matcher.RepeatMatcher;
import com.netflix.spectator.impl.matcher.SeqMatcher;
import com.netflix.spectator.impl.matcher.StartMatcher;
import com.netflix.spectator.impl.matcher.TrueMatcher;
import com.netflix.spectator.impl.matcher.ZeroOrMoreMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;

class Parser {
    private static final AsciiSet META = AsciiSet.fromPattern("?*+");
    private final String tokens;
    private int current;

    Parser(String tokens) {
        this.tokens = tokens;
        this.current = 0;
    }

    private IllegalArgumentException error(String message) {
        return PatternUtils.error(message, this.tokens, this.current);
    }

    private UnsupportedOperationException unsupported(String message) {
        return PatternUtils.unsupported(message, this.tokens, this.current);
    }

    Matcher parse() {
        Matcher m = this.expr();
        if (!this.isAtEnd()) {
            throw this.error("unmatched closing parenthesis");
        }
        return m;
    }

    private Matcher expr() {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        matchers.add(this.term());
        while (!this.isAtEnd() && this.peek() != ')' && this.peek() == '|') {
            this.advance();
            matchers.add(this.term());
        }
        if (!this.isAtEnd() && this.peek() == ')') {
            this.advance();
        }
        return OrMatcher.create(matchers);
    }

    private Matcher term() {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        block10: while (!this.isAtEnd() && this.peek() != ')' && this.peek() != '|') {
            char c = this.advance();
            switch (c) {
                case '\\': {
                    matchers.add(this.escape());
                    continue block10;
                }
                case '^': {
                    matchers.add(StartMatcher.INSTANCE);
                    continue block10;
                }
                case '$': {
                    matchers.add(EndMatcher.INSTANCE);
                    continue block10;
                }
                case '[': {
                    matchers.add(new CharClassMatcher(this.charClass()));
                    continue block10;
                }
                case '(': {
                    matchers.add(this.group());
                    continue block10;
                }
                case '{': {
                    matchers.add(this.repeat(this.pop(matchers)));
                    continue block10;
                }
                case '.': {
                    matchers.add(AnyMatcher.INSTANCE);
                    continue block10;
                }
                case '*': 
                case '+': 
                case '?': {
                    if (matchers.isEmpty()) {
                        throw this.error("dangling modifier");
                    }
                    matchers.add(this.meta(this.pop(matchers)));
                    continue block10;
                }
            }
            matchers.add(new CharSeqMatcher(c));
        }
        return SeqMatcher.create(matchers);
    }

    private Matcher pop(List<Matcher> matchers) {
        return matchers.remove(matchers.size() - 1);
    }

    private Matcher escape() {
        char c = this.peek();
        if (c == 'Q') {
            return this.quotation();
        }
        if (c == 'c') {
            throw this.unsupported("control character");
        }
        if (Constants.DIGIT.contains(c) || c == 'k') {
            throw this.unsupported("back references");
        }
        AsciiSet set = this.namedCharClass();
        if (set == null) {
            this.advance();
            return new CharSeqMatcher(String.valueOf(c));
        }
        return new CharClassMatcher(set);
    }

    private Matcher quotation() {
        int start = this.current + 1;
        int end = this.tokens.indexOf("\\E", start);
        if (end == -1) {
            throw this.error("unclosed quotation");
        }
        this.current = end + 2;
        return new CharSeqMatcher(this.tokens.substring(start, end));
    }

    private Matcher groupExpr() {
        Matcher m = this.expr();
        if (this.previous() != ')') {
            throw this.error("unclosed group");
        }
        return m;
    }

    private Matcher group() {
        if (this.peek() == '?') {
            this.advance();
            char c = this.advance();
            switch (c) {
                case '<': {
                    this.advance(v -> v != 62);
                    if (this.isAtEnd()) {
                        throw this.error("unclosed name for capturing group");
                    }
                    return this.groupExpr();
                }
                case ':': {
                    return this.groupExpr();
                }
                case '=': {
                    return new PositiveLookaheadMatcher(this.expr());
                }
                case '!': {
                    return new NegativeLookaheadMatcher(this.expr());
                }
            }
            throw this.unsupported("inline flags");
        }
        return this.groupExpr();
    }

    private AsciiSet namedCharClass() {
        boolean invert = false;
        char c = this.advance();
        switch (c) {
            case 'd': {
                return Constants.DIGIT;
            }
            case 'D': {
                return Constants.DIGIT.invert();
            }
            case 's': {
                return Constants.SPACE;
            }
            case 'S': {
                return Constants.SPACE.invert();
            }
            case 'w': {
                return Constants.WORD_CHARS;
            }
            case 'W': {
                return Constants.WORD_CHARS.invert();
            }
            case 'H': 
            case 'h': {
                throw this.unsupported("horizontal whitespace class");
            }
            case 'V': 
            case 'v': {
                throw this.unsupported("vertical whitespace class");
            }
            case 'P': {
                invert = true;
            }
            case 'p': {
                return this.newNamedCharSet(this.name(), invert);
            }
        }
        --this.current;
        return null;
    }

    private String name() {
        char c = this.advance();
        if (c == '{') {
            StringBuilder builder = new StringBuilder();
            while (this.peek() != '}') {
                builder.append(this.advance());
            }
            this.advance();
            return builder.toString();
        }
        return String.valueOf(c);
    }

    private AsciiSet update(AsciiSet s1, AsciiSet s2, boolean invert) {
        return invert ? s1.diff(s2) : s1.union(s2);
    }

    private AsciiSet charClass() {
        char c;
        boolean invert;
        AsciiSet set = AsciiSet.none();
        boolean rangeStart = false;
        boolean bl = invert = this.peek() == '^';
        if (invert) {
            this.advance();
            set = AsciiSet.all();
        }
        if (this.peek() == ']' || this.peek() == '-') {
            c = this.advance();
            set = this.update(set, AsciiSet.fromPattern(Character.toString(c)), invert);
        }
        block6: while (!this.isAtEnd() && this.peek() != ']') {
            c = this.advance();
            switch (c) {
                case '[': {
                    set = set.union(this.charClass());
                    rangeStart = false;
                    continue block6;
                }
                case '&': {
                    if (this.peek() == '&') {
                        this.advance();
                        if (this.peek() == '[') {
                            this.advance();
                            set = set.intersection(this.charClass());
                        } else if (this.peek() != ']') {
                            set = set.intersection(this.charClass());
                            --this.current;
                        }
                    } else {
                        set = this.update(set, AsciiSet.fromPattern(Character.toString(c)), invert);
                    }
                    rangeStart = false;
                    continue block6;
                }
                case '\\': {
                    AsciiSet tmp = this.namedCharClass();
                    if (tmp == null) {
                        c = this.advance();
                        rangeStart = true;
                        set = this.update(set, AsciiSet.fromPattern(Character.toString(c)), invert);
                        continue block6;
                    }
                    rangeStart = false;
                    set = this.update(set, tmp, invert);
                    continue block6;
                }
                case '-': {
                    AsciiSet tmp;
                    if (rangeStart && this.peek() != ']') {
                        String range;
                        if (this.peek() == '\\') {
                            this.advance();
                            tmp = this.namedCharClass();
                            if (tmp == null) {
                                range = this.tokens.subSequence(this.current - 3, this.current - 1).toString() + this.peek();
                                if (range.endsWith("\\")) {
                                    this.advance();
                                }
                                set = this.update(set, AsciiSet.fromPattern(range), invert);
                            } else {
                                set = this.update(set, AsciiSet.fromPattern("-"), invert);
                                set = this.update(set, tmp, invert);
                            }
                        } else {
                            range = this.tokens.subSequence(this.current - 2, this.current + 1).toString();
                            set = this.update(set, AsciiSet.fromPattern(range), invert);
                        }
                    } else {
                        set = this.update(set, AsciiSet.fromPattern("-"), invert);
                    }
                    rangeStart = false;
                    continue block6;
                }
            }
            rangeStart = true;
            set = this.update(set, AsciiSet.fromPattern(Character.toString(c)), invert);
        }
        if (this.advance() != ']') {
            throw this.error("unclosed character class");
        }
        return set;
    }

    private AsciiSet newNamedCharSet(String name, boolean invert) {
        AsciiSet set = Constants.NAMED_CHAR_CLASSES.get(name);
        if (set == null) {
            throw this.error("unknown character property name: " + name);
        }
        return invert ? set.invert() : set;
    }

    private Matcher repeat(Matcher matcher) {
        int start = this.current;
        this.advance(c -> c != 125);
        String[] numbers = this.tokens.subSequence(start, this.current - 1).toString().split(",");
        int min = Integer.parseInt(numbers[0]);
        int max = numbers.length > 1 ? Integer.parseInt(numbers[1]) : min;
        return new RepeatMatcher(matcher, min, max);
    }

    private Matcher meta(Matcher matcher) {
        String quantifier;
        int start = this.current - 1;
        this.advance(c -> META.contains((char)c));
        --this.current;
        switch (quantifier = this.tokens.subSequence(start, this.current).toString()) {
            case "?": {
                if (matcher instanceof RepeatMatcher) {
                    return matcher;
                }
            }
            case "??": 
            case "?+": {
                return OrMatcher.create(matcher, TrueMatcher.INSTANCE);
            }
            case "*": 
            case "*?": {
                return new ZeroOrMoreMatcher(matcher, this.term());
            }
            case "*+": {
                return new RepeatMatcher(matcher, 0, Integer.MAX_VALUE);
            }
            case "+": 
            case "+?": {
                return SeqMatcher.create(matcher, new ZeroOrMoreMatcher(matcher, this.term()));
            }
            case "++": {
                return SeqMatcher.create(matcher, new RepeatMatcher(matcher, 1, Integer.MAX_VALUE));
            }
        }
        throw new IllegalArgumentException("unknown quantifier: " + quantifier);
    }

    private boolean isAtEnd() {
        return this.current >= this.tokens.length();
    }

    private char peek() {
        return this.tokens.charAt(this.current);
    }

    private char previous() {
        return this.tokens.charAt(this.current - 1);
    }

    private char advance() {
        if (!this.isAtEnd()) {
            ++this.current;
        }
        return this.previous();
    }

    private void advance(IntPredicate condition) {
        while (!this.isAtEnd() && condition.test(this.advance())) {
        }
    }
}

