/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.netty.common.HttpRequestReadTimeoutEvent;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;

public class HttpRequestReadTimeoutHandler
extends ChannelInboundHandlerAdapter {
    private static final String HANDLER_NAME = "http_request_read_timeout_handler";
    private static final String INTERNAL_HANDLER_NAME = "http_request_read_timeout_internal";
    private final long timeout;
    private final TimeUnit unit;
    private final BasicCounter httpRequestReadTimeoutCounter;

    protected HttpRequestReadTimeoutHandler(long timeout, TimeUnit unit, BasicCounter httpRequestReadTimeoutCounter) {
        this.timeout = timeout;
        this.unit = unit;
        this.httpRequestReadTimeoutCounter = httpRequestReadTimeoutCounter;
    }

    public static void addLast(ChannelPipeline pipeline, long timeout, TimeUnit unit, BasicCounter httpRequestReadTimeoutCounter) {
        HttpRequestReadTimeoutHandler handler = new HttpRequestReadTimeoutHandler(timeout, unit, httpRequestReadTimeoutCounter);
        pipeline.addLast(HANDLER_NAME, (ChannelHandler)handler);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof LastHttpContent) {
            this.removeInternalHandler(ctx);
        } else if (msg instanceof HttpRequest) {
            InternalReadTimeoutHandler handler = new InternalReadTimeoutHandler(this.timeout, this.unit);
            ctx.pipeline().addBefore(HANDLER_NAME, INTERNAL_HANDLER_NAME, (ChannelHandler)handler);
        }
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpRequestReadTimeoutEvent) {
            CurrentPassport.fromChannel(ctx.channel()).add(PassportState.IN_REQ_READ_TIMEOUT);
            this.removeInternalHandler(ctx);
            this.httpRequestReadTimeoutCounter.increment();
        }
        super.userEventTriggered(ctx, evt);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.removeInternalHandler(ctx);
        super.handlerRemoved(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.removeInternalHandler(ctx);
        super.channelInactive(ctx);
    }

    protected void removeInternalHandler(ChannelHandlerContext ctx) {
        ChannelHandlerContext handlerContext = ctx.pipeline().context(INTERNAL_HANDLER_NAME);
        if (handlerContext != null && !handlerContext.isRemoved()) {
            ctx.pipeline().remove(INTERNAL_HANDLER_NAME);
        }
    }

    static class InternalReadTimeoutHandler
    extends ReadTimeoutHandler {
        public InternalReadTimeoutHandler(long timeout, TimeUnit unit) {
            super(timeout, unit);
        }

        protected void readTimedOut(ChannelHandlerContext ctx) throws Exception {
            ctx.fireUserEventTriggered((Object)HttpRequestReadTimeoutEvent.INSTANCE);
        }
    }
}

