/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.channel.config;

import com.netflix.netty.common.channel.config.ChannelConfigKey;
import com.netflix.netty.common.channel.config.ChannelConfigValue;
import java.util.HashMap;

public class ChannelConfig
implements Cloneable {
    private final HashMap<ChannelConfigKey, ChannelConfigValue> parameters;

    public ChannelConfig() {
        this.parameters = new HashMap();
    }

    public ChannelConfig(HashMap<ChannelConfigKey, ChannelConfigValue> parameters) {
        this.parameters = (HashMap)parameters.clone();
    }

    public void add(ChannelConfigValue param) {
        this.parameters.put(param.key(), param);
    }

    public <T> void set(ChannelConfigKey key, T value) {
        this.parameters.put(key, new ChannelConfigValue<T>(key, value));
    }

    public <T> T get(ChannelConfigKey<T> key) {
        T value;
        ChannelConfigValue ccv = this.parameters.get(key);
        T t = value = ccv == null ? null : (T)ccv.value();
        if (value == null) {
            value = key.defaultValue();
        }
        return value;
    }

    public <T> ChannelConfigValue<T> getConfig(ChannelConfigKey<T> key) {
        return this.parameters.get(key);
    }

    public <T> boolean contains(ChannelConfigKey<T> key) {
        return this.parameters.containsKey(key);
    }

    public ChannelConfig clone() {
        return new ChannelConfig(this.parameters);
    }
}

