/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.util.AttributeKey;

public class DynamicHttp2FrameLogger
extends Http2FrameLogger {
    public static final AttributeKey<Object> ATTR_ENABLE = AttributeKey.valueOf((String)"http2.frame.logger.enabled");

    public DynamicHttp2FrameLogger(LogLevel level, Class<?> clazz) {
        super(level, clazz);
    }

    protected boolean enabled(ChannelHandlerContext ctx) {
        return ctx.channel().hasAttr(ATTR_ENABLE);
    }

    @Override
    protected boolean enabled() {
        return true;
    }

    @Override
    public void logData(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream) {
        if (this.enabled(ctx)) {
            super.logData(direction, ctx, streamId, data, padding, endStream);
        }
    }

    @Override
    public void logHeaders(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        if (this.enabled(ctx)) {
            super.logHeaders(direction, ctx, streamId, headers, padding, endStream);
        }
    }

    @Override
    public void logHeaders(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        if (this.enabled(ctx)) {
            super.logHeaders(direction, ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
        }
    }

    @Override
    public void logPriority(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        if (this.enabled(ctx)) {
            super.logPriority(direction, ctx, streamId, streamDependency, weight, exclusive);
        }
    }

    @Override
    public void logRstStream(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, long errorCode) {
        if (this.enabled(ctx)) {
            super.logRstStream(direction, ctx, streamId, errorCode);
        }
    }

    @Override
    public void logSettingsAck(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx) {
        if (this.enabled(ctx)) {
            super.logSettingsAck(direction, ctx);
        }
    }

    @Override
    public void logSettings(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, Http2Settings settings) {
        if (this.enabled(ctx)) {
            super.logSettings(direction, ctx, settings);
        }
    }

    @Override
    public void logPing(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, ByteBuf data) {
        if (this.enabled(ctx)) {
            super.logPing(direction, ctx, data);
        }
    }

    @Override
    public void logPingAck(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, ByteBuf data) {
        if (this.enabled(ctx)) {
            super.logPingAck(direction, ctx, data);
        }
    }

    @Override
    public void logPushPromise(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        if (this.enabled(ctx)) {
            super.logPushPromise(direction, ctx, streamId, promisedStreamId, headers, padding);
        }
    }

    @Override
    public void logGoAway(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (this.enabled(ctx)) {
            super.logGoAway(direction, ctx, lastStreamId, errorCode, debugData);
        }
    }

    @Override
    public void logWindowsUpdate(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
        if (this.enabled(ctx)) {
            super.logWindowsUpdate(direction, ctx, streamId, windowSizeIncrement);
        }
    }

    @Override
    public void logUnknownFrame(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf data) {
        if (this.enabled(ctx)) {
            super.logUnknownFrame(direction, ctx, frameType, streamId, flags, data);
        }
    }
}

