/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.metrics;

import com.netflix.zuul.netty.SpectatorUtils;
import io.netty.buffer.ByteBuf;
import io.netty.util.ResourceLeakDetector;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

public class InstrumentedResourceLeakDetector<T>
extends ResourceLeakDetector<T> {
    private final AtomicInteger instancesLeakCounter;
    private final AtomicInteger leakCounter;

    public InstrumentedResourceLeakDetector(Class<?> resourceType, int samplingInterval) {
        super(resourceType, samplingInterval);
        this.instancesLeakCounter = SpectatorUtils.newGauge("NettyLeakDetector_instances", resourceType.getSimpleName(), new AtomicInteger());
        this.leakCounter = SpectatorUtils.newGauge("NettyLeakDetector", resourceType.getSimpleName(), new AtomicInteger());
    }

    public InstrumentedResourceLeakDetector(Class<?> resourceType, int samplingInterval, long maxActive) {
        this(resourceType, samplingInterval);
    }

    protected void reportTracedLeak(String resourceType, String records) {
        super.reportTracedLeak(resourceType, records);
        this.leakCounter.incrementAndGet();
        this.resetReportedLeaks();
    }

    protected void reportUntracedLeak(String resourceType) {
        super.reportUntracedLeak(resourceType);
        this.leakCounter.incrementAndGet();
        this.resetReportedLeaks();
    }

    protected void reportInstancesLeak(String resourceType) {
        super.reportInstancesLeak(resourceType);
        this.instancesLeakCounter.incrementAndGet();
        this.resetReportedLeaks();
    }

    private void resetReportedLeaks() {
        try {
            Field reportedLeaks = ResourceLeakDetector.class.getDeclaredField("reportedLeaks");
            reportedLeaks.setAccessible(true);
            Object f = reportedLeaks.get((Object)this);
            if (f instanceof Map) {
                ((Map)f).clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class InstrumentedResourceLeakDetectorTest {
        InstrumentedResourceLeakDetector<Object> leakDetector;

        @Before
        public void setup() {
            this.leakDetector = new InstrumentedResourceLeakDetector(ByteBuf.class, 1);
        }

        @Test
        public void test() {
            this.leakDetector.reportTracedLeak("test", "test");
            Assert.assertEquals((long)((InstrumentedResourceLeakDetector)this.leakDetector).leakCounter.get(), (long)1L);
            this.leakDetector.reportTracedLeak("test", "test");
            Assert.assertEquals((long)((InstrumentedResourceLeakDetector)this.leakDetector).leakCounter.get(), (long)2L);
            this.leakDetector.reportTracedLeak("test", "test");
            Assert.assertEquals((long)((InstrumentedResourceLeakDetector)this.leakDetector).leakCounter.get(), (long)3L);
        }
    }
}

