/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.dependency.cassandra;

import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraHelper {
    private static Logger LOG = LoggerFactory.getLogger(CassandraHelper.class);
    private static Keyspace zuulCassKeyspace;

    private CassandraHelper() {
    }

    public static CassandraHelper getInstance() {
        return CassandraHelperSingletonHolder.instance;
    }

    public Keyspace getZuulCassKeyspace() throws Exception {
        if (zuulCassKeyspace != null) {
            return zuulCassKeyspace;
        }
        try {
            this.setAstynaxConfiguration(ConfigurationManager.getConfigInstance());
            AstyanaxContext context = new AstyanaxContext.Builder().forKeyspace(DynamicPropertyFactory.getInstance().getStringProperty("zuul.cassandra.keyspace", "zuul_scripts").get()).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setDiscoveryType(NodeDiscoveryType.RING_DESCRIBE)).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl("cass_connection_pool").setPort(DynamicPropertyFactory.getInstance().getIntProperty("zuul.cassandra.port", 7102).get()).setMaxConnsPerHost(DynamicPropertyFactory.getInstance().getIntProperty("zuul.cassandra.maxConnectionsPerHost", 1).get()).setSeeds(DynamicPropertyFactory.getInstance().getStringProperty("zuul.cassandra.host", "").get() + ":" + DynamicPropertyFactory.getInstance().getIntProperty("zuul.cassandra.port", 7102).get())).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
            context.start();
            zuulCassKeyspace = (Keyspace)context.getClient();
            return zuulCassKeyspace;
        }
        catch (Exception e) {
            LOG.error("Exception occurred when initializing Cassandra keyspace: " + e);
            throw e;
        }
    }

    private void setAstynaxConfiguration(AbstractConfiguration configuration) {
        configuration.setProperty("default.nfastyanax.readConsistency", (Object)DynamicPropertyFactory.getInstance().getStringProperty("default.nfastyanax.readConsistency", "CL_ONE").get());
        configuration.setProperty("default.nfastyanax.writeConsistency", (Object)DynamicPropertyFactory.getInstance().getStringProperty("zuul.cassandra.default.nfastyanax.writeConsistency", "CL_ONE").get());
        configuration.setProperty("default.nfastyanax.socketTimeout", (Object)DynamicPropertyFactory.getInstance().getStringProperty("zuul.cassandra.default.nfastyanax.socketTimeout", "2000").get());
        configuration.setProperty("default.nfastyanax.maxConnsPerHost", (Object)DynamicPropertyFactory.getInstance().getStringProperty("zuul.cassandra.default.nfastyanax.maxConnsPerHost", "3").get());
        configuration.setProperty("default.nfastyanax.maxTimeoutWhenExhausted", (Object)DynamicPropertyFactory.getInstance().getStringProperty("zuul.cassandra.default.nfastyanax.maxTimeoutWhenExhausted", "2000").get());
        configuration.setProperty("default.nfastyanax.maxFailoverCount", (Object)DynamicPropertyFactory.getInstance().getStringProperty("zuul.cassandra.default.nfastyanax.maxFailoverCount", "1").get());
        configuration.setProperty("default.nfastyanax.failoverWaitTime", (Object)DynamicPropertyFactory.getInstance().getStringProperty("zuul.cassandra.default.nfastyanax.failoverWaitTime", "0").get());
    }

    private static class CassandraHelperSingletonHolder {
        static final CassandraHelper instance = new CassandraHelper();

        private CassandraHelperSingletonHolder() {
        }
    }
}

