/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.dependency.cassandra;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.dependency.cassandra.CassandraCache;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultCassandraCache<K>
implements CassandraCache<K> {
    private static final DynamicIntProperty maxCacheSize = DynamicPropertyFactory.getInstance().getIntProperty("zuul.cassandra.cache.max-size", 1000);
    private final ConcurrentMap<String, K> cacheMap;
    private final AtomicLong cacheHits = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    private float cacheHitRatio = 0.0f;
    private final String monitorName = this.getClass().getSimpleName();

    private DefaultCassandraCache() {
        this(new ConcurrentHashMap());
    }

    private DefaultCassandraCache(ConcurrentMap<String, K> cacheMap) {
        this.cacheMap = cacheMap;
    }

    @Override
    public K fetchQuery(String ... keys) {
        String key = DefaultCassandraCache.buildKey(keys);
        Object result = this.cacheMap.get(key);
        if (result != null) {
            this.cacheHits.incrementAndGet();
        } else {
            this.cacheMisses.incrementAndGet();
        }
        long currentHits = this.cacheHits.get();
        this.cacheHitRatio = (float)currentHits / (float)(currentHits + this.cacheMisses.get());
        return (K)result;
    }

    @Override
    public void storeQuery(K response, String ... keys) {
        int removeCount;
        String key = DefaultCassandraCache.buildKey(keys);
        if (!this.cacheMap.containsKey(key) && (removeCount = this.cacheMap.size() + 1 - this.getMaxCacheSize()) > 0) {
            Iterator it = this.cacheMap.keySet().iterator();
            for (int i = 0; i < removeCount; ++i) {
                if (!it.hasNext()) continue;
                it.next();
                it.remove();
            }
        }
        this.cacheMap.put(key, (String)response);
    }

    public long getCacheHits() {
        return this.cacheHits.get();
    }

    public long getCacheMisses() {
        return this.cacheMisses.get();
    }

    public double getCacheHitRatio() {
        return this.cacheHitRatio;
    }

    public long getCacheEntries() {
        return this.cacheMap.size();
    }

    private static final String buildKey(String ... keys) {
        return Arrays.toString(keys);
    }

    protected int getMaxCacheSize() {
        return maxCacheSize.get();
    }

    public static final class UnitTest {
        private static final String DOMAIN = "test-domain";
        private static final String QUERY1 = "test-query1";
        private static final String QUERY2 = "test-query2";
        @Mock
        HashMap<String, String> response1;
        @Mock
        HashMap<String, String> response2;
        @Mock
        ConcurrentMap<String, HashMap<String, String>> cacheMap;
        DefaultCassandraCache<HashMap<String, String>> cache;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
            this.cacheMap = new ConcurrentHashMap<String, HashMap<String, String>>();
            this.cache = new DefaultCassandraCache(this.cacheMap);
            this.cache = (DefaultCassandraCache)Mockito.spy(this.cache);
        }

        @Test
        public void storesItemIfCacheIsNotFull() {
            Mockito.when((Object)this.cache.getMaxCacheSize()).thenReturn((Object)5);
            String cacheKey1 = DefaultCassandraCache.buildKey(new String[]{DOMAIN, QUERY1});
            String cacheKey2 = DefaultCassandraCache.buildKey(new String[]{DOMAIN, QUERY2});
            this.cache.storeQuery(this.response1, DOMAIN, QUERY1);
            this.cache.storeQuery(this.response2, DOMAIN, QUERY2);
            Assert.assertSame(this.response1, this.cache.fetchQuery(DOMAIN, QUERY1));
            Assert.assertSame(this.response1, this.cacheMap.get(cacheKey1));
            Assert.assertSame(this.response2, this.cache.fetchQuery(DOMAIN, QUERY2));
            Assert.assertSame(this.response2, this.cacheMap.get(cacheKey2));
        }

        @Test
        public void removesItemIfCacheIsFull() {
            Mockito.when((Object)this.cache.getMaxCacheSize()).thenReturn((Object)1);
            String cacheKey1 = DefaultCassandraCache.buildKey(new String[]{DOMAIN, QUERY1});
            String cacheKey2 = DefaultCassandraCache.buildKey(new String[]{DOMAIN, QUERY2});
            this.cache.storeQuery(this.response1, DOMAIN, QUERY1);
            Assert.assertSame(this.response1, this.cache.fetchQuery(DOMAIN, QUERY1));
            Assert.assertSame(this.response1, this.cacheMap.get(cacheKey1));
            Assert.assertEquals((long)1L, (long)this.cacheMap.size());
            this.cache.storeQuery(this.response2, DOMAIN, QUERY2);
            Assert.assertSame(this.response2, this.cache.fetchQuery(DOMAIN, QUERY2));
            Assert.assertSame(this.response2, this.cacheMap.get(cacheKey2));
            Assert.assertEquals((long)1L, (long)this.cacheMap.size());
        }
    }
}

