/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters;

import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.http.Cookies;
import com.netflix.zuul.message.http.HttpQueryParams;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseInfo;
import com.netflix.zuul.message.http.HttpResponseMessage;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseFilterTest {
    @Mock
    protected HttpResponseMessage response;
    @Mock
    protected HttpRequestMessage request;
    @Mock
    protected HttpRequestInfo originalRequest;
    @Mock
    protected HttpResponseInfo originResponse;
    protected SessionContext context;
    protected Headers originalRequestHeaders;
    protected Headers requestHeaders;
    protected HttpQueryParams requestParams;
    protected Cookies requestCookies;
    protected Headers originResponseHeaders;
    protected Headers responseHeaders;

    @Before
    public void setup() {
        this.context = new SessionContext();
        Mockito.when((Object)this.request.getContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.response.getContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.request.getInboundRequest()).thenReturn((Object)this.originalRequest);
        Mockito.when((Object)this.response.getOutboundRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)this.response.getInboundRequest()).thenReturn((Object)this.originalRequest);
        Mockito.when((Object)this.response.getInboundResponse()).thenReturn((Object)this.originResponse);
        this.originResponseHeaders = new Headers();
        Mockito.when((Object)this.originResponse.getHeaders()).thenReturn((Object)this.originResponseHeaders);
        this.originalRequestHeaders = new Headers();
        this.requestHeaders = new Headers();
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)this.requestHeaders);
        Mockito.when((Object)this.originalRequest.getHeaders()).thenReturn((Object)this.originalRequestHeaders);
        this.requestParams = new HttpQueryParams();
        Mockito.when((Object)this.request.getQueryParams()).thenReturn((Object)this.requestParams);
        Mockito.when((Object)this.originalRequest.getQueryParams()).thenReturn((Object)this.requestParams);
        this.requestCookies = new Cookies();
        Mockito.when((Object)this.request.parseCookies()).thenReturn((Object)this.requestCookies);
        this.responseHeaders = new Headers();
        Mockito.when((Object)this.response.getHeaders()).thenReturn((Object)this.responseHeaders);
    }

    protected void setRequestHost(String host) {
        Mockito.when((Object)this.originalRequest.getOriginalHost()).thenReturn((Object)host);
    }
}

