/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters.common;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.config.DynamicStringSetProperty;
import com.netflix.zuul.filters.BaseFilterTest;
import com.netflix.zuul.filters.http.HttpOutboundSyncFilter;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import com.netflix.zuul.util.Gzipper;
import com.netflix.zuul.util.HttpUtils;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

public class GZipResponseFilter
extends HttpOutboundSyncFilter {
    private static DynamicStringSetProperty GZIPPABLE_CONTENT_TYPES = new DynamicStringSetProperty("zuul.gzip.contenttypes", "text/html,application/x-javascript,text/css,application/javascript,text/javascript,text/plain,text/xml,application/json,application/vnd.ms-fontobject,application/x-font-opentype,application/x-font-truetype,application/x-font-ttf,application/xml,font/eot,font/opentype,font/otf,image/svg+xml,image/vnd.microsoft.icon", ",");
    private static final CachedDynamicIntProperty MIN_BODY_SIZE_FOR_GZIP = new CachedDynamicIntProperty("zuul.min.gzip.body.size", 860);

    @Override
    public int filterOrder() {
        return 5;
    }

    @Override
    public boolean shouldFilter(HttpResponseMessage response) {
        boolean shouldGzip;
        if (!response.hasBody() || response.getContext().isInBrownoutMode()) {
            return false;
        }
        if (response.getContext().get("gzipper") != null) {
            return true;
        }
        HttpRequestInfo request = response.getInboundRequest();
        Boolean overrideIsGzipRequested = (Boolean)response.getContext().get("overrideGzipRequested");
        boolean isGzipRequested = overrideIsGzipRequested == null ? HttpUtils.acceptsGzip(request.getHeaders()) : overrideIsGzipRequested;
        Headers respHeaders = response.getHeaders();
        boolean isResponseGzipped = HttpUtils.isGzipped(respHeaders);
        boolean bl = shouldGzip = this.isGzippableContentType(response) && isGzipRequested && !isResponseGzipped && this.isRightSizeForGzip(response);
        if (shouldGzip) {
            response.getContext().set("gzipper", new Gzipper());
        }
        return shouldGzip;
    }

    @VisibleForTesting
    boolean isRightSizeForGzip(HttpResponseMessage response) {
        Integer bodySize = HttpUtils.getBodySizeIfKnown(response);
        return bodySize == null || bodySize >= MIN_BODY_SIZE_FOR_GZIP.get();
    }

    @Override
    public HttpResponseMessage apply(HttpResponseMessage response) {
        Headers respHeaders = response.getHeaders();
        respHeaders.set(HttpHeaderNames.CONTENT_ENCODING, "gzip");
        respHeaders.remove(HttpHeaderNames.CONTENT_LENGTH);
        return response;
    }

    private boolean isGzippableContentType(HttpResponseMessage response) {
        String ct = response.getHeaders().getFirst(HttpHeaderNames.CONTENT_TYPE);
        if (ct != null) {
            int charsetIndex = ct.indexOf(59);
            if (charsetIndex > 0) {
                ct = ct.substring(0, charsetIndex);
            }
            return GZIPPABLE_CONTENT_TYPES.get().contains(ct.toLowerCase());
        }
        return false;
    }

    @Override
    public HttpContent processContentChunk(ZuulMessage resp, HttpContent chunk) {
        Gzipper gzipper = (Gzipper)resp.getContext().get("gzipper");
        gzipper.write(chunk);
        if (chunk instanceof LastHttpContent) {
            gzipper.finish();
            return new DefaultLastHttpContent(gzipper.getByteBuf());
        }
        return new DefaultHttpContent(gzipper.getByteBuf());
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class TestUnit
    extends BaseFilterTest {
        GZipResponseFilter filter;
        HttpResponseMessage response;

        @Override
        @Before
        public void setup() {
            super.setup();
            this.filter = (GZipResponseFilter)Mockito.spy((Object)new GZipResponseFilter());
            this.response = new HttpResponseMessageImpl(this.context, this.request, 99);
            this.response.getHeaders().set(HttpHeaderNames.CONTENT_TYPE, "text/html");
        }

        @Test
        public void prepareResponseBody_NeedsGZipping() throws Exception {
            this.originalRequestHeaders.set("Accept-Encoding", "gzip");
            byte[] originBody = "blah".getBytes();
            this.response.getHeaders().set("Content-Length", Integer.toString(originBody.length));
            Mockito.when((Object)this.filter.isRightSizeForGzip(this.response)).thenReturn((Object)true);
            this.response.setHasBody(true);
            Assert.assertTrue((boolean)this.filter.shouldFilter(this.response));
            HttpResponseMessage result = this.filter.apply(this.response);
            HttpContent hc1 = this.filter.processContentChunk(this.response, new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])originBody)).retain());
            HttpContent hc2 = this.filter.processContentChunk(this.response, (HttpContent)new DefaultLastHttpContent());
            byte[] body = new byte[hc1.content().readableBytes() + hc2.content().readableBytes()];
            int hc1Len = hc1.content().readableBytes();
            int hc2Len = hc2.content().readableBytes();
            hc1.content().readBytes(body, 0, hc1Len);
            hc2.content().readBytes(body, hc1Len, hc2Len);
            byte[] unzippedBytes = IOUtils.toByteArray((InputStream)new GZIPInputStream(new ByteArrayInputStream(body)));
            String bodyStr = new String(unzippedBytes, "UTF-8");
            Assert.assertEquals((Object)"blah", (Object)bodyStr);
            Assert.assertEquals((Object)"gzip", (Object)result.getHeaders().getFirst("Content-Encoding"));
            Assert.assertEquals((long)0L, (long)result.getHeaders().get("Content-Length").size());
        }

        @Test
        public void prepareResponseBody_NeedsGZipping_butTooSmall() throws Exception {
            this.originalRequestHeaders.set("Accept-Encoding", "gzip");
            byte[] originBody = "blah".getBytes();
            this.response.getHeaders().set("Content-Length", Integer.toString(originBody.length));
            this.response.setHasBody(true);
            Assert.assertFalse((boolean)this.filter.shouldFilter(this.response));
        }

        @Test
        public void prepareChunkedEncodedResponseBody_NeedsGZipping() throws Exception {
            this.originalRequestHeaders.set("Accept-Encoding", "gzip");
            this.response.getHeaders().set("Transfer-Encoding", "chunked");
            this.response.setHasBody(true);
            Assert.assertTrue((boolean)this.filter.shouldFilter(this.response));
        }
    }
}

