/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message;

import com.netflix.config.DynamicPropertyFactory;

public class HeaderName {
    private static final boolean SHOULD_INTERN = DynamicPropertyFactory.getInstance().getBooleanProperty("com.netflix.zuul.message.HeaderName.shouldIntern", true).get();
    private final String name;
    private final String normalised;

    public HeaderName(String name) {
        if (name == null) {
            throw new NullPointerException("HeaderName cannot be null!");
        }
        this.name = SHOULD_INTERN ? name.intern() : name;
        this.normalised = SHOULD_INTERN ? name.toLowerCase().intern() : name.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public String getNormalised() {
        return this.normalised;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeaderName that = (HeaderName)o;
        if (SHOULD_INTERN) {
            return this.normalised == that.normalised;
        }
        return this.normalised.equals(that.normalised);
    }

    public int hashCode() {
        return this.normalised.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

