/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.Assert;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

public class HttpQueryParams
implements Cloneable {
    private final ListMultimap<String, String> delegate;
    private final boolean immutable;

    public HttpQueryParams() {
        this.delegate = ArrayListMultimap.create();
        this.immutable = false;
    }

    private HttpQueryParams(ListMultimap<String, String> delegate) {
        this.delegate = delegate;
        this.immutable = ImmutableListMultimap.class.isAssignableFrom(delegate.getClass());
    }

    public static HttpQueryParams parse(String queryString) {
        HttpQueryParams queryParams = new HttpQueryParams();
        if (queryString == null) {
            return queryParams;
        }
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreTokens()) {
            String name;
            String s = st.nextToken();
            int i = s.indexOf("=");
            if (i > 0) {
                name = s.substring(0, i);
                String value = s.substring(i + 1);
                try {
                    name = URLDecoder.decode(name, "UTF-8");
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                queryParams.add(name, value);
                continue;
            }
            if (s.length() <= 0) continue;
            name = s;
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            queryParams.add(name, "");
        }
        return queryParams;
    }

    public String getFirst(String name) {
        List values = this.delegate.get((Object)name);
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public List<String> get(String name) {
        return this.delegate.get((Object)name.toLowerCase());
    }

    public boolean contains(String name) {
        return this.delegate.containsKey((Object)name);
    }

    public boolean contains(String name, String value) {
        return this.delegate.containsEntry((Object)name, (Object)value);
    }

    public void set(String name, String value) {
        this.delegate.removeAll((Object)name);
        this.delegate.put((Object)name, (Object)value);
    }

    public void add(String name, String value) {
        this.delegate.put((Object)name, (Object)value);
    }

    public void removeAll(String name) {
        this.delegate.removeAll((Object)name);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Collection<Map.Entry<String, String>> entries() {
        return this.delegate.entries();
    }

    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    public String toEncodedString() {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : this.entries()) {
                sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                if (StringUtils.isNotEmpty((CharSequence)entry.getValue())) {
                    sb.append('=');
                    sb.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
                sb.append('&');
            }
            if (sb.length() > 0 && '&' == sb.charAt(sb.length() - 1)) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.entries()) {
            sb.append(entry.getKey());
            if (StringUtils.isNotEmpty((CharSequence)entry.getValue())) {
                sb.append('=');
                sb.append(entry.getValue());
            }
            sb.append('&');
        }
        if (sb.length() > 0 && '&' == sb.charAt(sb.length() - 1)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected HttpQueryParams clone() {
        HttpQueryParams copy = new HttpQueryParams();
        copy.delegate.putAll(this.delegate);
        return copy;
    }

    public HttpQueryParams immutableCopy() {
        return new HttpQueryParams((ListMultimap<String, String>)ImmutableListMultimap.copyOf(this.delegate));
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpQueryParams)) {
            return false;
        }
        HttpQueryParams hqp2 = (HttpQueryParams)obj;
        return Iterables.elementsEqual((Iterable)this.delegate.entries(), (Iterable)hqp2.delegate.entries());
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class TestUnit {
        @Test
        public void testMultiples() {
            HttpQueryParams qp = new HttpQueryParams();
            qp.add("k1", "v1");
            qp.add("k1", "v2");
            qp.add("k2", "v3");
            Assert.assertEquals((String)"k1=v1&k1=v2&k2=v3", (String)qp.toEncodedString());
        }

        @Test
        public void testToEncodedString() {
            HttpQueryParams qp = new HttpQueryParams();
            qp.add("k'1", "v1&");
            Assert.assertEquals((String)"k%271=v1%26", (String)qp.toEncodedString());
            qp = new HttpQueryParams();
            qp.add("k+", "\n");
            Assert.assertEquals((String)"k%2B=%0A", (String)qp.toEncodedString());
        }

        @Test
        public void testToString() {
            HttpQueryParams qp = new HttpQueryParams();
            qp.add("k'1", "v1&");
            Assert.assertEquals((String)"k'1=v1&", (String)qp.toString());
            qp = new HttpQueryParams();
            qp.add("k+", "\n");
            Assert.assertEquals((String)"k+=\n", (String)qp.toString());
        }

        @Test
        public void testEquals() {
            HttpQueryParams qp1 = new HttpQueryParams();
            qp1.add("k1", "v1");
            qp1.add("k2", "v2");
            HttpQueryParams qp2 = new HttpQueryParams();
            qp2.add("k1", "v1");
            qp2.add("k2", "v2");
            Assert.assertEquals((Object)qp1, (Object)qp2);
        }

        @Test
        public void testParseKeysWithoutValues() {
            HttpQueryParams expected = new HttpQueryParams();
            expected.add("k1", "");
            expected.add("k2", "v2");
            expected.add("k3", "");
            HttpQueryParams actual = HttpQueryParams.parse("k1=&k2=v2&k3=");
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.assertEquals((String)"k1&k2=v2&k3", (String)actual.toEncodedString());
        }

        @Test
        public void testParseKeyWithoutValueEquals() {
            HttpQueryParams expected = new HttpQueryParams();
            expected.add("k1", "");
            HttpQueryParams actual = HttpQueryParams.parse("k1=");
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.assertEquals((String)"k1", (String)actual.toEncodedString());
        }

        @Test
        public void testParseKeyWithoutValue() {
            HttpQueryParams expected = new HttpQueryParams();
            expected.add("k1", "");
            HttpQueryParams actual = HttpQueryParams.parse("k1");
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.assertEquals((String)"k1", (String)actual.toEncodedString());
        }

        @Test
        public void testParseKeyWithoutValueShort() {
            HttpQueryParams expected = new HttpQueryParams();
            expected.add("=", "");
            HttpQueryParams actual = HttpQueryParams.parse("=");
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.assertEquals((String)"%3D", (String)actual.toEncodedString());
        }
    }
}

