/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message.http;

import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.config.DynamicStringProperty;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.ZuulMessageImpl;
import com.netflix.zuul.message.http.Cookies;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpQueryParams;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.util.HttpUtils;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.HttpContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestMessageImpl
implements HttpRequestMessage {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestMessageImpl.class);
    private static final CachedDynamicIntProperty MAX_BODY_SIZE_PROP = new CachedDynamicIntProperty("zuul.HttpRequestMessage.body.max.size", 15360000);
    private static final CachedDynamicBooleanProperty CLEAN_COOKIES = new CachedDynamicBooleanProperty("zuul.HttpRequestMessage.cookies.clean", false);
    private static final DynamicStringProperty REGEX_PTNS_TO_STRIP_PROP = new DynamicStringProperty("zuul.request.cookie.cleaner.strip", " Secure,");
    private static final List<Pattern> RE_STRIP = new ArrayList<Pattern>();
    private static final Pattern PTN_COLON;
    private static final String URI_SCHEME_SEP = "://";
    private static final String URI_SCHEME_HTTP = "http";
    private static final String URI_SCHEME_HTTPS = "https";
    private final boolean immutable;
    private ZuulMessage message;
    private String protocol;
    private String method;
    private String path;
    private HttpQueryParams queryParams;
    private String clientIp;
    private String scheme;
    private int port;
    private String serverName;
    private HttpRequestInfo inboundRequest = null;
    private Cookies parsedCookies = null;
    private String reconstructedUri = null;
    private String pathAndQuery = null;
    private String infoForLogging = null;

    public HttpRequestMessageImpl(SessionContext context, String protocol, String method, String path, HttpQueryParams queryParams, Headers headers, String clientIp, String scheme, int port, String serverName) {
        this(context, protocol, method, path, queryParams, headers, clientIp, scheme, port, serverName, false);
    }

    public HttpRequestMessageImpl(SessionContext context, String protocol, String method, String path, HttpQueryParams queryParams, Headers headers, String clientIp, String scheme, int port, String serverName, boolean immutable) {
        this.immutable = immutable;
        this.message = new ZuulMessageImpl(context, headers);
        this.protocol = protocol;
        this.method = method;
        this.path = path;
        this.queryParams = queryParams == null ? new HttpQueryParams() : queryParams;
        this.clientIp = clientIp;
        this.scheme = scheme;
        this.port = port;
        this.serverName = serverName;
    }

    private void immutableCheck() {
        if (this.immutable) {
            throw new IllegalStateException("This HttpRequestMessageImpl is immutable. No mutating operations allowed!");
        }
    }

    @Override
    public SessionContext getContext() {
        return this.message.getContext();
    }

    @Override
    public Headers getHeaders() {
        return this.message.getHeaders();
    }

    @Override
    public void setHeaders(Headers newHeaders) {
        this.immutableCheck();
        this.message.setHeaders(newHeaders);
    }

    @Override
    public void setHasBody(boolean hasBody) {
        this.message.setHasBody(hasBody);
    }

    @Override
    public boolean hasBody() {
        return this.message.hasBody();
    }

    @Override
    public void bufferBodyContents(HttpContent chunk) {
        this.message.bufferBodyContents(chunk);
    }

    @Override
    public void setBodyAsText(String bodyText) {
        this.message.setBodyAsText(bodyText);
    }

    @Override
    public void setBody(byte[] body) {
        this.message.setBody(body);
    }

    @Override
    public boolean finishBufferedBodyIfIncomplete() {
        return this.message.finishBufferedBodyIfIncomplete();
    }

    @Override
    public Iterable<HttpContent> getBodyContents() {
        return this.message.getBodyContents();
    }

    @Override
    public void runBufferedBodyContentThroughFilter(ZuulFilter filter) {
        this.message.runBufferedBodyContentThroughFilter(filter);
    }

    @Override
    public String getBodyAsText() {
        return this.message.getBodyAsText();
    }

    @Override
    public byte[] getBody() {
        return this.message.getBody();
    }

    @Override
    public int getBodyLength() {
        return this.message.getBodyLength();
    }

    @Override
    public boolean hasCompleteBody() {
        return this.message.hasCompleteBody();
    }

    @Override
    public void disposeBufferedBody() {
        this.message.disposeBufferedBody();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) {
        this.immutableCheck();
        this.protocol = protocol;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String method) {
        this.immutableCheck();
        this.method = method;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.immutableCheck();
        this.path = path;
    }

    @Override
    public HttpQueryParams getQueryParams() {
        return this.queryParams;
    }

    @Override
    public String getPathAndQuery() {
        if (this.immutable) {
            if (this.pathAndQuery == null) {
                this.pathAndQuery = this.generatePathAndQuery();
            }
            return this.pathAndQuery;
        }
        return this.generatePathAndQuery();
    }

    protected String generatePathAndQuery() {
        if (this.queryParams != null && this.queryParams.entries().size() > 0) {
            return this.getPath() + "?" + this.queryParams.toEncodedString();
        }
        return this.getPath();
    }

    @Override
    public String getClientIp() {
        return this.clientIp;
    }

    @Override
    public void setClientIp(String clientIp) {
        this.immutableCheck();
        this.clientIp = clientIp;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void setScheme(String scheme) {
        this.immutableCheck();
        this.scheme = scheme;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.immutableCheck();
        this.port = port;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String serverName) {
        this.immutableCheck();
        this.serverName = serverName;
    }

    @Override
    public Cookies parseCookies() {
        if (this.parsedCookies == null) {
            this.parsedCookies = this.reParseCookies();
        }
        return this.parsedCookies;
    }

    @Override
    public Cookies reParseCookies() {
        Cookies cookies = new Cookies();
        for (String aCookieHeader : this.getHeaders().get(HttpHeaderNames.COOKIE)) {
            try {
                if (CLEAN_COOKIES.get()) {
                    aCookieHeader = HttpRequestMessageImpl.cleanCookieHeader(aCookieHeader);
                }
                Set decoded = CookieDecoder.decode((String)aCookieHeader, (boolean)false);
                for (Cookie cookie : decoded) {
                    cookies.add(cookie);
                }
            }
            catch (Exception e) {
                LOG.error(String.format("Error parsing request Cookie header. cookie=%s, request-info=%s", aCookieHeader, this.getInfoForLogging()));
            }
        }
        this.parsedCookies = cookies;
        return cookies;
    }

    private static String cleanCookieHeader(String cookie) {
        for (Pattern stripPtn : RE_STRIP) {
            Matcher matcher = stripPtn.matcher(cookie);
            if (!matcher.find()) continue;
            cookie = matcher.replaceAll("");
        }
        return cookie;
    }

    @Override
    public int getMaxBodySize() {
        return MAX_BODY_SIZE_PROP.get();
    }

    @Override
    public ZuulMessage clone() {
        HttpRequestMessageImpl clone = new HttpRequestMessageImpl(this.message.getContext().clone(), this.protocol, this.method, this.path, this.queryParams.clone(), this.message.getHeaders().clone(), this.clientIp, this.scheme, this.port, this.serverName);
        if (this.getInboundRequest() != null) {
            clone.inboundRequest = (HttpRequestInfo)this.getInboundRequest().clone();
        }
        return clone;
    }

    protected HttpRequestInfo copyRequestInfo() {
        HttpRequestMessageImpl req = new HttpRequestMessageImpl(this.message.getContext(), this.protocol, this.method, this.path, this.queryParams.immutableCopy(), this.message.getHeaders().immutableCopy(), this.clientIp, this.scheme, this.port, this.serverName, true);
        req.setHasBody(this.hasBody());
        return req;
    }

    @Override
    public void storeInboundRequest() {
        this.inboundRequest = this.copyRequestInfo();
    }

    @Override
    public HttpRequestInfo getInboundRequest() {
        return this.inboundRequest;
    }

    @Override
    public void setQueryParams(HttpQueryParams queryParams) {
        this.immutableCheck();
        this.queryParams = queryParams;
    }

    @Override
    public String getInfoForLogging() {
        if (this.immutable) {
            if (this.infoForLogging == null) {
                this.infoForLogging = this.generateInfoForLogging();
            }
            return this.infoForLogging;
        }
        return this.generateInfoForLogging();
    }

    protected String generateInfoForLogging() {
        HttpRequestInfo req = this.getInboundRequest() == null ? this : this.getInboundRequest();
        StringBuilder sb = new StringBuilder().append("uri=").append(req.reconstructURI()).append(", method=").append(req.getMethod()).append(", clientip=").append(HttpUtils.getClientIP(req));
        return sb.toString();
    }

    @Override
    public String getOriginalHost() {
        String host = this.getHeaders().getFirst(HttpHeaderNames.X_FORWARDED_HOST);
        if (host == null) {
            host = this.getHeaders().getFirst(HttpHeaderNames.HOST);
            if (host != null) {
                host = PTN_COLON.split(host)[0];
            }
            if (host == null) {
                host = this.getServerName();
            }
        }
        return host;
    }

    @Override
    public String getOriginalScheme() {
        String scheme = this.getHeaders().getFirst(HttpHeaderNames.X_FORWARDED_PROTO);
        if (scheme == null) {
            scheme = this.getScheme();
        }
        return scheme;
    }

    @Override
    public String getOriginalProtocol() {
        String proto = this.getHeaders().getFirst(HttpHeaderNames.X_FORWARDED_PROTO_VERSION);
        if (proto == null) {
            proto = this.getProtocol();
        }
        return proto;
    }

    @Override
    public int getOriginalPort() {
        String[] hostParts;
        String hostHeader;
        String portStr = this.getHeaders().getFirst(HttpHeaderNames.X_FORWARDED_PORT);
        int port = portStr == null ? ((hostHeader = this.getHeaders().getFirst(HttpHeaderNames.HOST)) != null ? ((hostParts = PTN_COLON.split(hostHeader)).length == 2 ? Integer.parseInt(hostParts[1]) : this.getPort()) : this.getPort()) : Integer.parseInt(portStr);
        return port;
    }

    @Override
    public String reconstructURI() {
        if (this.immutable) {
            if (this.reconstructedUri == null) {
                this.reconstructedUri = this._reconstructURI();
            }
            return this.reconstructedUri;
        }
        return this._reconstructURI();
    }

    protected String _reconstructURI() {
        try {
            StringBuilder uri = new StringBuilder(100);
            String scheme = this.getOriginalScheme().toLowerCase();
            uri.append(scheme);
            uri.append(URI_SCHEME_SEP).append(this.getOriginalHost());
            int port = this.getOriginalPort();
            if (!(URI_SCHEME_HTTP.equals(scheme) && 80 == port || URI_SCHEME_HTTPS.equals(scheme) && 443 == port)) {
                uri.append(':').append(port);
            }
            uri.append(this.getPathAndQuery());
            return uri.toString();
        }
        catch (Exception e) {
            LOG.error("Error reconstructing request URI!", (Throwable)e);
            return "";
        }
    }

    public String toString() {
        return "HttpRequestMessageImpl{immutable=" + this.immutable + ", message=" + this.message + ", protocol='" + this.protocol + '\'' + ", method='" + this.method + '\'' + ", path='" + this.path + '\'' + ", queryParams=" + this.queryParams + ", clientIp='" + this.clientIp + '\'' + ", scheme='" + this.scheme + '\'' + ", port=" + this.port + ", serverName='" + this.serverName + '\'' + ", inboundRequest=" + this.inboundRequest + ", parsedCookies=" + this.parsedCookies + ", reconstructedUri='" + this.reconstructedUri + '\'' + ", pathAndQuery='" + this.pathAndQuery + '\'' + ", infoForLogging='" + this.infoForLogging + '\'' + '}';
    }

    static {
        for (String ptn : REGEX_PTNS_TO_STRIP_PROP.get().split(":::")) {
            RE_STRIP.add(Pattern.compile(ptn));
        }
        PTN_COLON = Pattern.compile(":");
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class TestUnit {
        HttpRequestMessageImpl request;

        @Test
        public void testOriginalRequestInfo() {
            HttpQueryParams queryParams = new HttpQueryParams();
            queryParams.add("flag", "5");
            Headers headers = new Headers();
            headers.add("Host", "blah.netflix.com");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            this.request.storeInboundRequest();
            HttpRequestInfo originalRequest = this.request.getInboundRequest();
            Assert.assertEquals((long)this.request.getPort(), (long)originalRequest.getPort());
            Assert.assertEquals((Object)this.request.getPath(), (Object)originalRequest.getPath());
            Assert.assertEquals((Object)this.request.getQueryParams().getFirst("flag"), (Object)originalRequest.getQueryParams().getFirst("flag"));
            Assert.assertEquals((Object)this.request.getHeaders().getFirst("Host"), (Object)originalRequest.getHeaders().getFirst("Host"));
            this.request.setPort(8080);
            this.request.setPath("/another/place");
            this.request.getQueryParams().set("flag", "20");
            this.request.getHeaders().set("Host", "wah.netflix.com");
            Assert.assertEquals((long)7002L, (long)originalRequest.getPort());
            Assert.assertEquals((Object)"/some/where", (Object)originalRequest.getPath());
            Assert.assertEquals((Object)"5", (Object)originalRequest.getQueryParams().getFirst("flag"));
            Assert.assertEquals((Object)"blah.netflix.com", (Object)originalRequest.getHeaders().getFirst("Host"));
        }

        @Test
        public void testReconstructURI() {
            HttpQueryParams queryParams = new HttpQueryParams();
            queryParams.add("flag", "5");
            Headers headers = new Headers();
            headers.add("Host", "blah.netflix.com");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((Object)"https://blah.netflix.com:7002/some/where?flag=5", (Object)this.request.reconstructURI());
            queryParams = new HttpQueryParams();
            headers = new Headers();
            headers.add("X-Forwarded-Host", "place.netflix.com");
            headers.add("X-Forwarded-Port", "80");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTP, 7002, "localhost");
            Assert.assertEquals((Object)"http://place.netflix.com/some/where", (Object)this.request.reconstructURI());
            queryParams = new HttpQueryParams();
            headers = new Headers();
            headers.add("X-Forwarded-Host", "place.netflix.com");
            headers.add("X-Forwarded-Proto", HttpRequestMessageImpl.URI_SCHEME_HTTPS);
            headers.add("X-Forwarded-Port", "443");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTP, 7002, "localhost");
            Assert.assertEquals((Object)"https://place.netflix.com/some/where", (Object)this.request.reconstructURI());
            queryParams = new HttpQueryParams();
            headers = new Headers();
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTP, 7002, "localhost");
            Assert.assertEquals((Object)"http://localhost:7002/some/where", (Object)this.request.reconstructURI());
            queryParams = new HttpQueryParams();
            queryParams.add("flag", "5");
            queryParams.add("flag B", "9");
            headers = new Headers();
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some%20where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((Object)"https://localhost:7002/some%20where?flag=5&flag+B=9", (Object)this.request.reconstructURI());
        }

        @Test
        public void testReconstructURI_immutable() {
            HttpQueryParams queryParams = new HttpQueryParams();
            queryParams.add("flag", "5");
            Headers headers = new Headers();
            headers.add("Host", "blah.netflix.com");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost", true);
            Assert.assertEquals((Object)"https://blah.netflix.com:7002/some/where?flag=5", (Object)this.request.reconstructURI());
            Assert.assertEquals((Object)"https://blah.netflix.com:7002/some/where?flag=5", (Object)this.request.reconstructURI());
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost", true);
            this.request = (HttpRequestMessageImpl)Mockito.spy((Object)this.request);
            Mockito.when((Object)this.request._reconstructURI()).thenReturn((Object)"http://testhost/blah");
            ((HttpRequestMessageImpl)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1)))._reconstructURI();
            Assert.assertEquals((Object)"http://testhost/blah", (Object)this.request.reconstructURI());
            Assert.assertEquals((Object)"http://testhost/blah", (Object)this.request.reconstructURI());
            try {
                this.request.setPath("/new-path");
                Assert.fail();
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)true);
            }
        }

        @Test
        public void testPathAndQuery() {
            HttpQueryParams queryParams = new HttpQueryParams();
            queryParams.add("flag", "5");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, new Headers(), "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((Object)"/some/where?flag=5", (Object)this.request.getPathAndQuery());
            this.request.getQueryParams().add("k", "v");
            Assert.assertEquals((Object)"/some/where?flag=5&k=v", (Object)this.request.getPathAndQuery());
            this.request.setPath("/other");
            Assert.assertEquals((Object)"/other?flag=5&k=v", (Object)this.request.getPathAndQuery());
        }

        @Test
        public void testPathAndQuery_immutable() {
            HttpQueryParams queryParams = new HttpQueryParams();
            queryParams.add("flag", "5");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, new Headers(), "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost", true);
            Assert.assertEquals((Object)"/some/where?flag=5", (Object)this.request.getPathAndQuery());
            Assert.assertEquals((Object)"/some/where?flag=5", (Object)this.request.getPathAndQuery());
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, new Headers(), "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost", true);
            this.request = (HttpRequestMessageImpl)Mockito.spy((Object)this.request);
            Mockito.when((Object)this.request.generatePathAndQuery()).thenReturn((Object)"/blah");
            ((HttpRequestMessageImpl)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).generatePathAndQuery();
            Assert.assertEquals((Object)"/blah", (Object)this.request.getPathAndQuery());
            Assert.assertEquals((Object)"/blah", (Object)this.request.getPathAndQuery());
        }

        @Test
        public void testGetOriginalHost() {
            HttpQueryParams queryParams = new HttpQueryParams();
            Headers headers = new Headers();
            headers.add("Host", "blah.netflix.com");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((Object)"blah.netflix.com", (Object)this.request.getOriginalHost());
            headers = new Headers();
            headers.add("Host", "blah.netflix.com");
            headers.add("X-Forwarded-Host", "foo.netflix.com");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((Object)"foo.netflix.com", (Object)this.request.getOriginalHost());
            headers = new Headers();
            headers.add("X-Forwarded-Host", "foo.netflix.com");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((Object)"foo.netflix.com", (Object)this.request.getOriginalHost());
            headers = new Headers();
            headers.add("Host", "blah.netflix.com:8080");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((Object)"blah.netflix.com", (Object)this.request.getOriginalHost());
        }

        @Test
        public void testGetOriginalPort() {
            HttpQueryParams queryParams = new HttpQueryParams();
            Headers headers = new Headers();
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((long)7002L, (long)this.request.getOriginalPort());
            headers = new Headers();
            headers.add("Host", "blah.netflix.com");
            headers.add("X-Forwarded-Port", "443");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((long)443L, (long)this.request.getOriginalPort());
            headers = new Headers();
            headers.add("Host", "blah.netflix.com:443");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((long)443L, (long)this.request.getOriginalPort());
            headers = new Headers();
            headers.add("Host", "blah.netflix.com:443");
            headers.add("X-Forwarded-Port", "7005");
            this.request = new HttpRequestMessageImpl(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", HttpRequestMessageImpl.URI_SCHEME_HTTPS, 7002, "localhost");
            Assert.assertEquals((long)7005L, (long)this.request.getOriginalPort());
        }

        @Test
        public void testCleanCookieHeaders() {
            Assert.assertEquals((Object)"BlahId=12345; something=67890;", (Object)HttpRequestMessageImpl.cleanCookieHeader("BlahId=12345; Secure, something=67890;"));
            Assert.assertEquals((Object)"BlahId=12345; something=67890;", (Object)HttpRequestMessageImpl.cleanCookieHeader("BlahId=12345; something=67890;"));
            Assert.assertEquals((Object)" BlahId=12345; something=67890;", (Object)HttpRequestMessageImpl.cleanCookieHeader(" Secure, BlahId=12345; Secure, something=67890;"));
            Assert.assertEquals((Object)"", (Object)HttpRequestMessageImpl.cleanCookieHeader(""));
        }
    }
}

