/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty;

import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Timer;

public final class SpectatorUtils {
    private SpectatorUtils() {
    }

    public static Counter newCounter(String name, String id) {
        return Spectator.globalRegistry().counter(name, new String[]{"id", id});
    }

    public static Counter newCounter(String name, String id, String ... tags) {
        String[] allTags = SpectatorUtils.getTagsWithId(id, tags);
        return Spectator.globalRegistry().counter(name, allTags);
    }

    public static Timer newTimer(String name, String id) {
        return Spectator.registry().timer(name, new String[]{"id", id});
    }

    public static Timer newTimer(String name, String id, String ... tags) {
        return Spectator.globalRegistry().timer(name, SpectatorUtils.getTagsWithId(id, tags));
    }

    public static <T extends Number> T newGauge(String name, String id, T number) {
        CompositeRegistry registry = Spectator.globalRegistry();
        Id gaugeId = registry.createId(name, new String[]{"id", id});
        return (T)registry.gauge(gaugeId, number);
    }

    public static <T extends Number> T newGauge(String name, String id, T number, String ... tags) {
        CompositeRegistry registry = Spectator.globalRegistry();
        Id gaugeId = registry.createId(name, SpectatorUtils.getTagsWithId(id, tags));
        return (T)registry.gauge(gaugeId, number);
    }

    private static String[] getTagsWithId(String id, String[] tags) {
        String[] allTags = new String[tags.length + 2];
        System.arraycopy(tags, 0, allTags, 0, tags.length);
        allTags[allTags.length - 2] = "id";
        allTags[allTags.length - 1] = id;
        return allTags;
    }
}

