/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.filter;

import com.google.common.base.Preconditions;
import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.netty.common.HttpRequestReadTimeoutEvent;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.filters.endpoint.ProxyEndpoint;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import com.netflix.zuul.netty.RequestCancelledEvent;
import com.netflix.zuul.netty.filter.ZuulEndPointRunner;
import com.netflix.zuul.netty.filter.ZuulFilterChainRunner;
import com.netflix.zuul.stats.status.StatusCategory;
import com.netflix.zuul.stats.status.StatusCategoryUtils;
import com.netflix.zuul.stats.status.ZuulStatusCategory;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZuulFilterChainHandler
extends ChannelInboundHandlerAdapter {
    private final ZuulFilterChainRunner<HttpRequestMessage> requestFilterChain;
    private final ZuulFilterChainRunner<HttpResponseMessage> responseFilterChain;
    private HttpRequestMessage zuulRequest;
    private static final Logger LOG = LoggerFactory.getLogger(ZuulFilterChainHandler.class);

    public ZuulFilterChainHandler(ZuulFilterChainRunner<HttpRequestMessage> requestFilterChain, ZuulFilterChainRunner<HttpResponseMessage> responseFilterChain) {
        this.requestFilterChain = (ZuulFilterChainRunner)Preconditions.checkNotNull(requestFilterChain, (Object)"request filter chain");
        this.responseFilterChain = (ZuulFilterChainRunner)Preconditions.checkNotNull(responseFilterChain, (Object)"response filter chain");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequestMessage) {
            this.zuulRequest = (HttpRequestMessage)msg;
            SessionContext zuulCtx = this.zuulRequest.getContext();
            zuulCtx.put("_netty_server_channel_handler_context", ctx);
            zuulCtx.put("_zuul_filter_chain", this.requestFilterChain);
            this.requestFilterChain.filter(this.zuulRequest);
        } else if (msg instanceof HttpContent && this.zuulRequest != null) {
            this.requestFilterChain.filter(this.zuulRequest, (HttpContent)msg);
        } else {
            LOG.debug("Received unrecognized message type. " + msg.getClass().getName());
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
            HttpLifecycleChannelHandler.CompleteEvent completeEvent = (HttpLifecycleChannelHandler.CompleteEvent)evt;
            this.fireEndpointFinish(completeEvent.getReason() != HttpLifecycleChannelHandler.CompleteReason.SESSION_COMPLETE);
        } else if (evt instanceof HttpRequestReadTimeoutEvent) {
            this.sendResponse(ZuulStatusCategory.FAILURE_CLIENT_TIMEOUT, 408, ctx);
        } else if (evt instanceof IdleStateEvent) {
            this.sendResponse(ZuulStatusCategory.FAILURE_LOCAL_IDLE_TIMEOUT, 504, ctx);
        } else if (evt instanceof RequestCancelledEvent) {
            if (this.zuulRequest != null) {
                StatusCategoryUtils.storeStatusCategoryIfNotAlreadyFailure(this.zuulRequest.getContext(), ZuulStatusCategory.FAILURE_CLIENT_CANCELLED);
            }
            this.fireEndpointFinish(true);
            ctx.close();
        } else if (evt instanceof HttpLifecycleChannelHandler.RejectedPipeliningEvent) {
            this.sendResponse(ZuulStatusCategory.FAILURE_CLIENT_PIPELINE_REJECT, 400, ctx);
        }
        super.userEventTriggered(ctx, evt);
    }

    private void sendResponse(StatusCategory statusCategory, int status, ChannelHandlerContext ctx) {
        if (this.zuulRequest == null) {
            ctx.close();
        } else {
            SessionContext zuulCtx = this.zuulRequest.getContext();
            StatusCategoryUtils.storeStatusCategoryIfNotAlreadyFailure(zuulCtx, statusCategory);
            HttpResponseMessageImpl zuulResponse = new HttpResponseMessageImpl(zuulCtx, this.zuulRequest, status);
            Headers headers = zuulResponse.getHeaders();
            headers.add("Connection", "close");
            headers.add("Content-Length", "0");
            zuulResponse.finishBufferedBodyIfIncomplete();
            this.responseFilterChain.filter(zuulResponse);
            this.fireEndpointFinish(true);
        }
    }

    protected HttpRequestMessage getZuulRequest() {
        return this.zuulRequest;
    }

    protected void fireEndpointFinish(boolean error) {
        ZuulFilter<HttpRequestMessage, HttpResponseMessage> endpoint = ZuulEndPointRunner.getEndpoint(this.zuulRequest);
        if (endpoint instanceof ProxyEndpoint) {
            ProxyEndpoint edgeProxyEndpoint = (ProxyEndpoint)endpoint;
            edgeProxyEndpoint.finish(error);
        }
        this.zuulRequest = null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("zuul filter chain handler caught exception. cause=" + String.valueOf(cause), cause);
        if (this.zuulRequest != null) {
            SessionContext zuulCtx = this.zuulRequest.getContext();
            zuulCtx.setError(cause);
            zuulCtx.setShouldSendErrorResponse(true);
            this.sendResponse(ZuulStatusCategory.FAILURE_LOCAL, 500, ctx);
        } else {
            this.fireEndpointFinish(true);
            ctx.close();
        }
    }
}

