/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.insights;

import com.netflix.zuul.netty.insights.PassportStateListener;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;

public class PassportStateHttpClientHandler
extends CombinedChannelDuplexHandler {
    public static final String PASSPORT_STATE_HTTP_CLIENT_HANDLER_NAME = "PassportStateHttpClientHandler";

    public PassportStateHttpClientHandler() {
        super((ChannelInboundHandler)new InboundHandler(), (ChannelOutboundHandler)new OutboundHandler());
    }

    private static CurrentPassport passport(ChannelHandlerContext ctx) {
        return CurrentPassport.fromChannel(ctx.channel());
    }

    private static class OutboundHandler
    extends ChannelOutboundHandlerAdapter {
        private OutboundHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            try {
                CurrentPassport passport = PassportStateHttpClientHandler.passport(ctx);
                if (msg instanceof HttpRequest) {
                    passport.add(PassportState.OUT_REQ_HEADERS_SENDING);
                    promise.addListener((GenericFutureListener)new PassportStateListener(passport, PassportState.OUT_REQ_HEADERS_SENT, PassportState.OUT_REQ_HEADERS_ERROR_SENDING));
                }
                if (msg instanceof LastHttpContent) {
                    passport.add(PassportState.OUT_REQ_LAST_CONTENT_SENDING);
                    promise.addListener((GenericFutureListener)new PassportStateListener(passport, PassportState.OUT_REQ_LAST_CONTENT_SENT, PassportState.OUT_REQ_LAST_CONTENT_ERROR_SENDING));
                } else if (msg instanceof HttpContent) {
                    passport.add(PassportState.OUT_REQ_CONTENT_SENDING);
                    promise.addListener((GenericFutureListener)new PassportStateListener(passport, PassportState.OUT_REQ_CONTENT_SENT, PassportState.OUT_REQ_CONTENT_ERROR_SENDING));
                }
            }
            finally {
                super.write(ctx, msg, promise);
            }
        }
    }

    private static class InboundHandler
    extends ChannelInboundHandlerAdapter {
        private InboundHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                CurrentPassport passport = PassportStateHttpClientHandler.passport(ctx);
                if (msg instanceof HttpResponse) {
                    passport.add(PassportState.IN_RESP_HEADERS_RECEIVED);
                }
                if (msg instanceof LastHttpContent) {
                    passport.add(PassportState.IN_RESP_LAST_CONTENT_RECEIVED);
                } else if (msg instanceof HttpContent) {
                    passport.add(PassportState.IN_RESP_CONTENT_RECEIVED);
                }
            }
            finally {
                super.channelRead(ctx, msg);
            }
        }
    }
}

