/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.http2;

import com.netflix.netty.common.Http2ConnectionCloseHandler;
import com.netflix.netty.common.Http2ConnectionExpiryHandler;
import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.netty.common.channel.config.CommonChannelConfigKeys;
import com.netflix.netty.common.metrics.Http2MetricsChannelHandlers;
import com.netflix.netty.common.ssl.ServerSslConfig;
import com.netflix.zuul.logging.Http2FrameLoggingPerClientIpHandler;
import com.netflix.zuul.netty.server.BaseZuulChannelInitializer;
import com.netflix.zuul.netty.server.http2.DummyChannelHandler;
import com.netflix.zuul.netty.server.http2.Http2Configuration;
import com.netflix.zuul.netty.server.http2.Http2OrHttpHandler;
import com.netflix.zuul.netty.server.http2.Http2StreamInitializer;
import com.netflix.zuul.netty.ssl.SslContextFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2SslChannelInitializer
extends BaseZuulChannelInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(Http2SslChannelInitializer.class);
    private static final DummyChannelHandler DUMMY_HANDLER = new DummyChannelHandler();
    private final ServerSslConfig serverSslConfig;
    private final SslContext sslContext;
    private final boolean isSSlFromIntermediary;

    public Http2SslChannelInitializer(int port, ChannelConfig channelConfig, ChannelConfig channelDependencies, ChannelGroup channels) {
        super(port, channelConfig, channelDependencies, channels);
        this.serverSslConfig = channelConfig.get(CommonChannelConfigKeys.serverSslConfig);
        this.isSSlFromIntermediary = channelConfig.get(CommonChannelConfigKeys.isSSlFromIntermediary);
        SslContextFactory sslContextFactory = channelConfig.get(CommonChannelConfigKeys.sslContextFactory);
        this.sslContext = Http2Configuration.configureSSL(sslContextFactory, port);
    }

    protected void initChannel(Channel ch) throws Exception {
        SslHandler sslHandler = this.sslContext.newHandler(ch.alloc());
        sslHandler.engine().setEnabledProtocols(this.serverSslConfig.getProtocols());
        if (LOG.isDebugEnabled()) {
            LOG.debug("ssl protocols supported: {}", (Object)String.join((CharSequence)", ", sslHandler.engine().getSupportedProtocols()));
            LOG.debug("ssl protocols enabled: {}", (Object)String.join((CharSequence)", ", sslHandler.engine().getEnabledProtocols()));
            LOG.debug("ssl ciphers supported: {}", (Object)String.join((CharSequence)", ", sslHandler.engine().getSupportedCipherSuites()));
            LOG.debug("ssl ciphers enabled: {}", (Object)String.join((CharSequence)", ", sslHandler.engine().getEnabledCipherSuites()));
        }
        ChannelPipeline pipeline = ch.pipeline();
        this.storeChannel(ch);
        this.addTimeoutHandlers(pipeline);
        this.addPassportHandler(pipeline);
        this.addTcpRelatedHandlers(pipeline);
        pipeline.addLast(new ChannelHandler[]{new Http2FrameLoggingPerClientIpHandler()});
        pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        this.addSslInfoHandlers(pipeline, this.isSSlFromIntermediary);
        this.addSslClientCertChecks(pipeline);
        Http2MetricsChannelHandlers http2MetricsChannelHandlers = new Http2MetricsChannelHandlers(this.registry, "server", "http2-" + this.port);
        Http2ConnectionCloseHandler connectionCloseHandler = new Http2ConnectionCloseHandler(this.channelConfig.get(CommonChannelConfigKeys.connCloseDelay));
        Http2ConnectionExpiryHandler connectionExpiryHandler = new Http2ConnectionExpiryHandler(this.maxRequestsPerConnection, this.maxRequestsPerConnectionInBrownout, this.connectionExpiry);
        pipeline.addLast("http2CodecSwapper", (ChannelHandler)new Http2OrHttpHandler((ChannelHandler)new Http2StreamInitializer(ch, this::http1Handlers, http2MetricsChannelHandlers, connectionCloseHandler, connectionExpiryHandler), this.channelConfig, cp -> {
            this.http1Codec((ChannelPipeline)cp);
            this.http1Handlers((ChannelPipeline)cp);
        }));
        pipeline.addLast("codec_placeholder", (ChannelHandler)DUMMY_HANDLER);
    }

    protected void http1Handlers(ChannelPipeline pipeline) {
        this.addHttpRelatedHandlers(pipeline);
        this.addZuulHandlers(pipeline);
    }

    protected void http1Codec(ChannelPipeline pipeline) {
        pipeline.replace("codec_placeholder", "codec", (ChannelHandler)this.createHttpServerCodec());
    }
}

