/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.scriptManager;

import com.netflix.zuul.filters.FilterType;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class FilterInfo
implements Comparable<FilterInfo> {
    private final String filter_id;
    private final String filter_name;
    private final String filter_code;
    private final FilterType filter_type;
    private final String filter_disablePropertyName;
    private final String filter_order;
    private final String application_name;
    private int revision;
    private Date creationDate;
    private final AtomicBoolean isActive = new AtomicBoolean();
    private final AtomicBoolean isCanary = new AtomicBoolean();

    public FilterInfo(String filter_id, String filter_code, FilterType filter_type, String filter_name, String disablePropertyName, String filter_order, String application_name) {
        this.filter_id = filter_id;
        this.filter_code = filter_code;
        this.filter_type = filter_type;
        this.filter_name = filter_name;
        this.filter_disablePropertyName = disablePropertyName;
        this.filter_order = filter_order;
        this.application_name = application_name;
        this.isActive.set(false);
        this.isCanary.set(false);
    }

    public String getFilterName() {
        return this.filter_name;
    }

    public String getFilterCode() {
        return this.filter_code;
    }

    public String getFilterDisablePropertyName() {
        return this.filter_disablePropertyName;
    }

    public FilterType getFilterType() {
        return this.filter_type;
    }

    public String toString() {
        return "FilterInfo{filter_id='" + this.filter_id + '\'' + ", filter_name='" + this.filter_name + '\'' + ", filter_type='" + (Object)((Object)this.filter_type) + '\'' + ", revision=" + this.revision + ", creationDate=" + this.creationDate + ", isActive=" + this.isActive + ", isCanary=" + this.isCanary + ", application_name=" + this.application_name + '}';
    }

    public String getApplication_name() {
        return this.application_name;
    }

    public FilterInfo(String filter_id, int revision, Date creationDate, boolean isActive, boolean isCanary, String filter_code, FilterType filter_type, String filter_name, String disablePropertyName, String filter_order, String application_name) {
        this.filter_id = filter_id;
        this.revision = revision;
        this.creationDate = creationDate;
        this.isActive.set(isActive);
        this.isCanary.set(isCanary);
        this.filter_code = filter_code;
        this.filter_name = filter_name;
        this.filter_type = filter_type;
        this.filter_order = filter_order;
        this.filter_disablePropertyName = disablePropertyName;
        this.application_name = application_name;
    }

    public int getRevision() {
        return this.revision;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public boolean isCanary() {
        return this.isCanary.get();
    }

    public String getFilterID() {
        return this.filter_id;
    }

    public String getFilterOrder() {
        return this.filter_order;
    }

    public static String buildFilterID(String application_name, FilterType filter_type, String filter_name) {
        return application_name + ":" + filter_name + ":" + filter_type.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterInfo that = (FilterInfo)o;
        if (this.revision != that.revision) {
            return false;
        }
        if (this.creationDate != null ? !this.creationDate.equals(that.creationDate) : that.creationDate != null) {
            return false;
        }
        if (this.filter_code != null ? !this.filter_code.equals(that.filter_code) : that.filter_code != null) {
            return false;
        }
        if (this.filter_id != null ? !this.filter_id.equals(that.filter_id) : that.filter_id != null) {
            return false;
        }
        if (this.filter_name != null ? !this.filter_name.equals(that.filter_name) : that.filter_name != null) {
            return false;
        }
        if (this.filter_type != null ? !this.filter_type.equals((Object)that.filter_type) : that.filter_type != null) {
            return false;
        }
        if (this.isActive != null ? this.isActive.get() != that.isActive.get() : that.isActive != null) {
            return false;
        }
        return !(this.isCanary != null ? this.isCanary.get() != that.isCanary.get() : that.isCanary != null);
    }

    public int hashCode() {
        int result = this.filter_id != null ? this.filter_id.hashCode() : 0;
        result = 31 * result + (this.filter_name != null ? this.filter_name.hashCode() : 0);
        result = 31 * result + (this.filter_code != null ? this.filter_code.hashCode() : 0);
        result = 31 * result + (this.filter_type != null ? this.filter_type.hashCode() : 0);
        result = 31 * result + this.revision;
        result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
        result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
        result = 31 * result + (this.isCanary != null ? this.isCanary.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(FilterInfo filterInfo) {
        if (filterInfo.getFilterName().equals(this.getFilterName())) {
            return filterInfo.creationDate.compareTo(this.getCreationDate());
        }
        return filterInfo.getFilterName().compareTo(this.getFilterName());
    }
}

