/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.scriptManager;

import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.zuul.ZuulApplicationInfo;
import com.netflix.zuul.dependency.cassandra.hystrix.HystrixCassandraGetRowsByKeys;
import com.netflix.zuul.dependency.cassandra.hystrix.HystrixCassandraGetRowsByQuery;
import com.netflix.zuul.dependency.cassandra.hystrix.HystrixCassandraPut;
import com.netflix.zuul.event.ZuulEvent;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.scriptManager.FilterInfo;
import com.netflix.zuul.scriptManager.ZuulFilterDAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import net.jcip.annotations.ThreadSafe;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ZuulFilterDAOCassandra
extends Observable
implements ZuulFilterDAO {
    private static final Logger logger = LoggerFactory.getLogger(ZuulFilterDAOCassandra.class);
    private final CassandraGateway cassandraGateway;
    private static final String APPLICATION_SCRIPTS = "APPLICATION_";
    private static final String ACTIVE_SCRIPTS = "ACTIVE_";
    private static final String CANARY_SCRIPTS = "CANARY_";
    private static final String SCRIPTS_FOR_FILTER = "FILTERSCRIPTS_";
    private static final String FILTER_ID = "FILTER_ID_";
    static Keyspace keyspace;

    public static Keyspace getCassKeyspace() {
        return keyspace;
    }

    public ZuulFilterDAOCassandra(Keyspace keyspace) {
        this(new CassandraGatewayProd(keyspace));
        ZuulFilterDAOCassandra.keyspace = keyspace;
    }

    private ZuulFilterDAOCassandra(CassandraGateway cassandraGateway) {
        this.cassandraGateway = cassandraGateway;
    }

    public void addFilterIdToIndex(String index, String filter_id) {
        String filterIds = this.getFilterIdsRaw(index);
        if (filterIds.contains(filter_id)) {
            return;
        }
        filterIds = "".equals(filterIds) ? filterIds + filter_id : filterIds + "|" + filter_id;
        this.cassandraGateway.updateFilterIndex(index, filterIds);
    }

    @Override
    public String getFilterIdsRaw(String index) {
        Rows<String, String> result = this.cassandraGateway.select("select filter_ids from zuul_filter_indices where index_name = '" + index + "'");
        if (result == null || result.isEmpty()) {
            return "";
        }
        Iterator iterator = result.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            try {
                String filter_ids = row.getColumns().getColumnByName((Object)"filter_ids").getStringValue();
                if (filter_ids == null) {
                    return "";
                }
                return filter_ids;
            }
            catch (Exception e) {
                logger.warn("Unable to retrieve uri for row", (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public List<String> getFilterIdsIndex(String index) {
        String filter_ids = this.getFilterIdsRaw(index);
        if (filter_ids == null || "".equals(filter_ids)) {
            return new ArrayList<String>();
        }
        String[] aFilterIds = filter_ids.split("[|]");
        List<String> l = Arrays.asList(aFilterIds);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(l);
        return list;
    }

    public List<FilterInfo> getFiltersForIndex(String index) {
        List<String> filterInfoList = this.getFilterIdsIndex(index);
        if (filterInfoList.isEmpty()) {
            return Collections.emptyList();
        }
        Rows<String, String> result = this.cassandraGateway.getByFilterIds(filterInfoList);
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FilterInfo> filterInfos = new ArrayList<FilterInfo>();
        for (Row row : result) {
            FilterInfo script = this.getFilterScriptFromCassandraRow((Row<String, String>)row);
            if (script == null) continue;
            filterInfos.add(script);
        }
        Collections.sort(filterInfos);
        return filterInfos;
    }

    @Override
    public List<String> getAllFilterIDs() {
        return this.getFilterIdsIndex(FILTER_ID + ZuulApplicationInfo.getApplicationName());
    }

    @Override
    public FilterInfo getFilterInfo(String filter_id, int revision) {
        List<FilterInfo> filters = this.getZuulFiltersForFilterId(filter_id);
        if (filters == null) {
            return null;
        }
        for (FilterInfo filter : filters) {
            if (filter.getRevision() != revision) continue;
            return filter;
        }
        return null;
    }

    private String getScriptsForFilterIndexKey(String filter_id) {
        return SCRIPTS_FOR_FILTER + ZuulApplicationInfo.getApplicationName() + "_" + filter_id;
    }

    @Override
    public List<FilterInfo> getZuulFiltersForFilterId(String filter_id) {
        List<FilterInfo> filterInfos = this.getFiltersForIndex(this.getScriptsForFilterIndexKey(filter_id));
        if (filterInfos == null) {
            return Collections.emptyList();
        }
        if (filterInfos.size() == 0) {
            return filterInfos;
        }
        Collections.sort(filterInfos);
        return filterInfos;
    }

    @Override
    public FilterInfo getFilterInfoForFilter(String filter_id, int revision) {
        return this.getFilterInfo(filter_id, revision);
    }

    @Override
    public FilterInfo getLatestFilterInfoForFilter(String filter_id) {
        int largestRevision = 0;
        FilterInfo latestfilterInfo = null;
        List<FilterInfo> filterInfos = this.getFiltersForIndex(this.getScriptsForFilterIndexKey(filter_id));
        if (filterInfos == null) {
            return null;
        }
        if (filterInfos.size() == 0) {
            return null;
        }
        for (FilterInfo filterInfo : filterInfos) {
            if (filterInfo.getRevision() <= largestRevision) continue;
            largestRevision = filterInfo.getRevision();
            latestfilterInfo = filterInfo;
        }
        return latestfilterInfo;
    }

    @Override
    public FilterInfo getActiveFilterInfoForFilter(String filter_id) {
        List<FilterInfo> filterInfos = this.getFiltersForIndex(ACTIVE_SCRIPTS + ZuulApplicationInfo.getApplicationName());
        for (int i = 0; i < filterInfos.size(); ++i) {
            FilterInfo filterInfo = filterInfos.get(i);
            if (!filterInfo.getFilterID().equals(filter_id)) continue;
            return filterInfo;
        }
        return null;
    }

    public FilterInfo getCanaryScriptForFilter(String filter_id) {
        List<FilterInfo> filterInfos = this.getFiltersForIndex(CANARY_SCRIPTS + ZuulApplicationInfo.getApplicationName());
        for (int i = 0; i < filterInfos.size(); ++i) {
            FilterInfo filterInfo = filterInfos.get(i);
            if (!filterInfo.getFilterID().equals(filter_id)) continue;
            return filterInfo;
        }
        return null;
    }

    @Override
    public List<FilterInfo> getAllCanaryFilters() {
        List<FilterInfo> filterInfos = this.getFiltersForIndex(CANARY_SCRIPTS + ZuulApplicationInfo.getApplicationName());
        if (filterInfos == null || filterInfos.size() == 0) {
            return Collections.emptyList();
        }
        Collections.sort(filterInfos);
        return filterInfos;
    }

    @Override
    public List<FilterInfo> getAllActiveFilters() {
        List<FilterInfo> filterInfos = this.getFiltersForIndex(ACTIVE_SCRIPTS + ZuulApplicationInfo.getApplicationName());
        if (filterInfos == null || filterInfos.size() == 0) {
            return Collections.emptyList();
        }
        Collections.sort(filterInfos);
        return filterInfos;
    }

    public FilterInfo getFilterScriptFromCassandraRow(Row<String, String> row) {
        String filterName = null;
        int revision = -1;
        try {
            ColumnList columns = row.getColumns();
            filterName = columns.getColumnByName((Object)"filter_name").getStringValue();
            String filter_id = columns.getColumnByName((Object)"filter_id").getStringValue();
            FilterType filterType = FilterType.valueOf(columns.getColumnByName((Object)"filter_type").getStringValue());
            String filterDisable = columns.getColumnByName((Object)"filter_disable") != null ? columns.getColumnByName((Object)"filter_disable").getStringValue() : "?";
            String filterOrder = columns.getColumnByName((Object)"filter_order") != null ? columns.getColumnByName((Object)"filter_order").getStringValue() : "?";
            revision = (int)columns.getColumnByName((Object)"revision").getLongValue();
            boolean isActive = columns.getColumnByName((Object)"active").getBooleanValue();
            boolean isCanary = columns.getColumnByName((Object)"canary").getBooleanValue();
            Date creationDate = columns.getColumnByName((Object)"creation_date").getDateValue();
            String filterCode = new String(columns.getColumnByName((Object)"filter_code").getByteArrayValue());
            String application_name = columns.getColumnByName((Object)"application_name").getStringValue();
            FilterInfo filterInfo = new FilterInfo(filter_id, revision, creationDate, isActive, isCanary, filterCode, filterType, filterName, filterDisable, filterOrder, application_name);
            return filterInfo;
        }
        catch (Exception e) {
            logger.warn("Unable to retrieve data from row => uri : " + filterName + "  revision: " + revision + "  row: " + row, (Throwable)e);
            return null;
        }
    }

    @Override
    public FilterInfo addFilter(String filtercode, FilterType filter_type, String filter_name, String disableFilterPropertyName, String filter_order) {
        String filter_id = ZuulFilterDAOCassandra.buildFilterID(filter_type, filter_name);
        FilterInfo latest = this.getLatestFilterInfoForFilter(filter_id);
        int revision = 1;
        if (latest != null) {
            revision = latest.getRevision() + 1;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("filter_name", filter_name);
        attributes.put("filter_type", (Object)filter_type);
        attributes.put("filter_id", filter_id);
        attributes.put("revision", Long.valueOf(revision));
        attributes.put("active", false);
        attributes.put("canary", false);
        attributes.put("creation_date", Calendar.getInstance().getTime());
        attributes.put("filter_code", filtercode.getBytes());
        attributes.put("filter_disable", disableFilterPropertyName);
        attributes.put("filter_order", filter_order);
        attributes.put("application_name", ZuulApplicationInfo.getApplicationName());
        this.cassandraGateway.upsert(filter_id + "_" + revision, attributes);
        List<String> filterIds = this.getFilterIdsIndex(FILTER_ID + ZuulApplicationInfo.getApplicationName());
        if (!filterIds.contains(filter_id)) {
            this.addFilterIdToIndex(FILTER_ID + ZuulApplicationInfo.getApplicationName(), filter_id);
        }
        this.addFilterIdToIndex(APPLICATION_SCRIPTS + ZuulApplicationInfo.getApplicationName(), filter_id + "_" + revision);
        this.addFilterIdToIndex(this.getScriptsForFilterIndexKey(filter_id), filter_id + "_" + revision);
        return this.getFilterInfoForFilter(filter_id, revision);
    }

    public static String buildFilterID(FilterType filter_type, String filter_name) {
        return FilterInfo.buildFilterID(ZuulApplicationInfo.getApplicationName(), filter_type, filter_name);
    }

    @Override
    public FilterInfo setCanaryFilter(String filter_id, int revision) {
        ArrayList<Integer> revisionsToDeactivate = new ArrayList<Integer>();
        FilterInfo filterInfo = this.getCanaryScriptForFilter(filter_id);
        if (filterInfo != null) {
            revisionsToDeactivate.add(filterInfo.getRevision());
            this.removeFilterIdFromIndex(ACTIVE_SCRIPTS + ZuulApplicationInfo.getApplicationName(), filter_id + "_" + filterInfo.getRevision());
            this.removeFilterIdFromIndex(CANARY_SCRIPTS + ZuulApplicationInfo.getApplicationName(), filter_id + "_" + filterInfo.getRevision());
        }
        HashMap<String, Object> attributesForActivation = new HashMap<String, Object>();
        attributesForActivation.put("canary", true);
        attributesForActivation.put("active", false);
        this.cassandraGateway.upsert(filter_id + "_" + revision, attributesForActivation);
        this.addFilterIdToIndex(CANARY_SCRIPTS + ZuulApplicationInfo.getApplicationName(), filter_id + "_" + revision);
        Iterator iterator = revisionsToDeactivate.iterator();
        while (iterator.hasNext()) {
            int revisionToDeactivate = (Integer)iterator.next();
            if (revisionToDeactivate == revision) continue;
            HashMap<String, Object> attributesForDeactivation = new HashMap<String, Object>();
            attributesForDeactivation.put("canary", false);
            this.cassandraGateway.upsert(filter_id + "_" + revisionToDeactivate, attributesForDeactivation);
        }
        this.setChanged();
        this.notifyObservers(new ZuulEvent("ZUUL_SCRIPT_CHANGE", "CANARY FILTER SET id = " + filter_id + "revision = " + revision));
        return this.getFilterInfoForFilter(filter_id, revision);
    }

    private void removeFilterIdFromIndex(String index, String filter_id) {
        List<String> filters = this.getFilterIdsIndex(index);
        if (filters.contains(filter_id)) {
            filters.remove(filter_id);
            String filterList = this.toFilterList(filters);
            this.cassandraGateway.updateFilterIndex(index, filterList);
        }
    }

    private String toFilterList(List<String> filterList) {
        String list = "";
        Iterator<String> iterator = filterList.iterator();
        while (iterator.hasNext()) {
            String filter_info = iterator.next();
            list = list + filter_info;
            if (!iterator.hasNext()) continue;
            list = list + "|";
        }
        return list;
    }

    @Override
    public FilterInfo setFilterActive(String filter_id, int revision) throws Exception {
        FilterInfo filter = this.getFilterInfo(filter_id, revision);
        if (filter == null) {
            throw new Exception("Filter not Found " + filter_id + "revision:" + revision);
        }
        if ("prod".equals(System.getenv("netflix.environment")) && !filter.isCanary()) {
            throw new Exception("Filter must be canaried before activated " + filter_id + "revision:" + revision);
        }
        ArrayList<Integer> revisionsToDeactivate = new ArrayList<Integer>();
        FilterInfo filterInfo = this.getActiveFilterInfoForFilter(filter_id);
        if (filterInfo != null) {
            revisionsToDeactivate.add(filterInfo.getRevision());
            this.removeFilterIdFromIndex(ACTIVE_SCRIPTS + ZuulApplicationInfo.getApplicationName(), filter_id + "_" + filterInfo.getRevision());
        }
        this.removeFilterIdFromIndex(CANARY_SCRIPTS + ZuulApplicationInfo.getApplicationName(), filter_id + "_" + revision);
        this.addFilterIdToIndex(ACTIVE_SCRIPTS + ZuulApplicationInfo.getApplicationName(), filter_id + "_" + revision);
        HashMap<String, Object> attributesForActivation = new HashMap<String, Object>();
        attributesForActivation.put("active", true);
        attributesForActivation.put("canary", false);
        this.cassandraGateway.upsert(filter_id + "_" + revision, attributesForActivation);
        Iterator iterator = revisionsToDeactivate.iterator();
        while (iterator.hasNext()) {
            int revisionToDeactivate = (Integer)iterator.next();
            if (revisionToDeactivate == revision) continue;
            HashMap<String, Object> attributesForDeactivation = new HashMap<String, Object>();
            attributesForDeactivation.put("active", false);
            this.cassandraGateway.upsert(filter_id + "_" + revisionToDeactivate, attributesForDeactivation);
        }
        this.setChanged();
        this.notifyObservers(new ZuulEvent("ZUUL_SCRIPT_CHANGE", "ACTIVATED NEW ZUUL FILTER id = " + filter_id + " revision = " + revision));
        return this.getFilterInfoForFilter(filter_id, revision);
    }

    @Override
    public FilterInfo deActivateFilter(String filter_id, int revision) throws Exception {
        FilterInfo filter = this.getFilterInfo(filter_id, revision);
        if (filter == null) {
            throw new Exception("Filter not Found " + filter_id + "revision:" + revision);
        }
        if (!filter.isCanary() && !filter.isActive()) {
            throw new Exception("Filter must be canary or active to deactivate" + filter_id + "revision:" + revision);
        }
        this.removeFilterIdFromIndex(ACTIVE_SCRIPTS + ZuulApplicationInfo.getApplicationName(), filter_id + "_" + filter.getRevision());
        this.removeFilterIdFromIndex(CANARY_SCRIPTS + ZuulApplicationInfo.getApplicationName(), filter_id + "_" + filter.getRevision());
        HashMap<String, Object> attributesForActivation = new HashMap<String, Object>();
        attributesForActivation.put("active", false);
        attributesForActivation.put("canary", false);
        this.cassandraGateway.upsert(filter_id + "_" + revision, attributesForActivation);
        this.setChanged();
        this.notifyObservers(new ZuulEvent("ZUUL_SCRIPT_CHANGE", "DEACTIVATED ZUUL FILTER id = " + filter_id + " revision = " + revision));
        return this.getFilterInfoForFilter(filter_id, revision);
    }

    public static class UnitTest {
        @Mock
        CassandraGateway gateway;
        @Mock
        Rows<String, String> response;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testGetAllFiltersReturnsEmptyListInsteadOfNullWhenNoFilters() {
            ZuulFilterDAOCassandra dao = new ZuulFilterDAOCassandra(this.gateway);
            Mockito.when(this.gateway.select(Matchers.anyString())).thenReturn(this.response);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)true);
            List<String> list = dao.getAllFilterIDs();
            Assert.assertNotNull(list);
            Assert.assertEquals((long)0L, (long)list.size());
        }

        @Test
        public void testGetFilterIdsRawIndex() {
            ZuulFilterDAOCassandra dao = new ZuulFilterDAOCassandra(this.gateway);
            String fids = "filter1|filter2|filter3";
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_ids", fids);
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when(iterator.next()).thenReturn(row0, (Object[])new Row[]{null});
            Mockito.when(this.gateway.select(Matchers.anyString())).thenReturn(this.response);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)1);
            String list = dao.getFilterIdsRaw("index");
            Assert.assertEquals((Object)fids, (Object)list);
        }

        @Test
        public void testGetFilterIdsIndex() {
            ZuulFilterDAOCassandra dao = new ZuulFilterDAOCassandra(this.gateway);
            String fids = "filter1|filter2|filter3";
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_ids", fids);
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when(iterator.next()).thenReturn(row0, (Object[])new Row[]{null});
            Mockito.when(this.gateway.select(Matchers.anyString())).thenReturn(this.response);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)1);
            List<String> list = dao.getFilterIdsIndex("index");
            Assert.assertEquals((long)list.size(), (long)3L);
            Assert.assertEquals((Object)list.get(0), (Object)"filter1");
            Assert.assertEquals((Object)list.get(1), (Object)"filter2");
            Assert.assertEquals((Object)list.get(2), (Object)"filter3");
        }

        @Test
        public void testGetAllEndpointsReturnsResults() {
            ZuulFilterDAOCassandra dao = new ZuulFilterDAOCassandra(this.gateway);
            String fids = "filter1|filter2";
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_ids", fids);
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when(iterator.next()).thenReturn(row0, (Object[])new Row[]{null});
            Mockito.when(this.gateway.select(Matchers.anyString())).thenReturn(this.response);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)1);
            List<String> list = dao.getAllFilterIDs();
            Assert.assertEquals((Object)"filter1", (Object)list.get(0));
            Assert.assertEquals((Object)"filter2", (Object)list.get(1));
        }

        @Test
        public void testGetScriptForEndpointReturnsEmptyListInsteadOfNullWhenEndpointNotFound() {
            ZuulFilterDAOCassandra dao = new ZuulFilterDAOCassandra(this.gateway);
            Mockito.when(this.gateway.select(Matchers.anyString())).thenReturn(this.response);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)true);
            List<FilterInfo> list = dao.getZuulFiltersForFilterId("/unknown/Filter");
            Assert.assertNotNull(list);
            Assert.assertEquals((long)0L, (long)list.size());
        }

        @Test
        public void testGetScriptsForFilterReturnsResults() {
            ZuulFilterDAO dao = new ZuulFilterDAOCassandra(this.gateway);
            dao = (ZuulFilterDAO)Mockito.spy((Object)dao);
            ((ZuulFilterDAO)Mockito.doReturn((Object)"name:in_1|name:in_2").when((Object)dao)).getFilterIdsRaw(Matchers.anyString());
            String filter = "name:in";
            Calendar now = Calendar.getInstance();
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_id", filter);
            UnitTest.mockColumn(columnList0, "filter_name", "name");
            UnitTest.mockColumn(columnList0, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList0, "revision", 1L);
            UnitTest.mockColumn(columnList0, "active", true);
            UnitTest.mockColumn(columnList0, "canary", false);
            UnitTest.mockColumn(columnList0, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList0, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList0, "application_name", "app_name");
            Row<String, String> row1 = UnitTest.mockRow();
            ColumnList<String> columnList1 = UnitTest.mockColumnList(row1);
            UnitTest.mockColumn(columnList1, "filter_id", filter);
            UnitTest.mockColumn(columnList1, "revision", 2L);
            UnitTest.mockColumn(columnList1, "filter_name", "name");
            UnitTest.mockColumn(columnList1, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList1, "active", false);
            UnitTest.mockColumn(columnList1, "canary", false);
            UnitTest.mockColumn(columnList1, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList1, "filter_code", "script body 2a".getBytes());
            UnitTest.mockColumn(columnList1, "application_name", "app_name");
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
            Mockito.when(iterator.next()).thenReturn(row0, (Object[])new Row[]{row1, null});
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)2);
            Mockito.when(this.gateway.getByFilterIds(Mockito.anyList())).thenReturn(this.response);
            List<FilterInfo> list = dao.getZuulFiltersForFilterId(filter);
            Assert.assertEquals((Object)filter, (Object)list.get(0).getFilterID());
            Assert.assertEquals((long)1L, (long)list.get(0).getRevision());
            Assert.assertEquals((Object)true, (Object)list.get(0).isActive());
            Assert.assertEquals((Object)now.getTime(), (Object)list.get(0).getCreationDate());
            Assert.assertEquals((Object)filter, (Object)list.get(1).getFilterID());
            Assert.assertEquals((long)2L, (long)list.get(1).getRevision());
            Assert.assertEquals((Object)false, (Object)list.get(1).isActive());
            Assert.assertEquals((Object)"script body 2a", (Object)list.get(1).getFilterCode());
        }

        @Test
        public void testGetScriptForEndpointAndRevisionReturnsNullWhenNotFound() {
            ZuulFilterDAOCassandra dao = new ZuulFilterDAOCassandra(this.gateway);
            Mockito.when(this.gateway.select(Matchers.anyString())).thenReturn(this.response);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)true);
            FilterInfo filterInfo = dao.getFilterInfoForFilter("/unknown/filter", 2);
            Assert.assertNull((Object)filterInfo);
        }

        @Test
        public void testGetScriptForEndpointAndRevision() {
            ZuulFilterDAO dao = new ZuulFilterDAOCassandra(this.gateway);
            String filter = "name:in";
            Calendar now = Calendar.getInstance();
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_id", filter);
            UnitTest.mockColumn(columnList0, "revision", 3L);
            UnitTest.mockColumn(columnList0, "active", true);
            UnitTest.mockColumn(columnList0, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList0, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList0, "filter_name", "name");
            UnitTest.mockColumn(columnList0, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList0, "canary", false);
            UnitTest.mockColumn(columnList0, "application_name", "app_name");
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when(iterator.next()).thenReturn(row0, (Object[])new Row[]{null});
            Mockito.when((Object)this.response.getRowByIndex(0)).thenReturn(row0);
            Mockito.when(this.gateway.getByFilterIds(Mockito.anyList())).thenReturn(this.response);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)1);
            dao = (ZuulFilterDAO)Mockito.spy((Object)dao);
            ((ZuulFilterDAO)Mockito.doReturn((Object)"name:in_3").when((Object)dao)).getFilterIdsRaw(Matchers.anyString());
            FilterInfo filterInfo = dao.getFilterInfoForFilter(filter, 3);
            Assert.assertEquals((Object)filter, (Object)filterInfo.getFilterID());
            Assert.assertEquals((long)3L, (long)filterInfo.getRevision());
            Assert.assertEquals((Object)true, (Object)filterInfo.isActive());
            Assert.assertEquals((Object)now.getTime(), (Object)filterInfo.getCreationDate());
            Assert.assertEquals((Object)"script body 1", (Object)filterInfo.getFilterCode());
        }

        @Test
        public void testGetScriptForLatestEndpointReturnsNullWhenNotFound() {
            ZuulFilterDAOCassandra dao = new ZuulFilterDAOCassandra(this.gateway);
            Mockito.when(this.gateway.select(Matchers.anyString())).thenReturn(this.response);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)true);
            FilterInfo filterInfo = dao.getLatestFilterInfoForFilter("/unknown/filter");
            Assert.assertNull((Object)filterInfo);
        }

        @Test
        public void testGetScriptForLatestEndpoint() {
            ZuulFilterDAO dao = new ZuulFilterDAOCassandra(this.gateway);
            String filter = "name:in";
            Calendar now = Calendar.getInstance();
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_id", filter);
            UnitTest.mockColumn(columnList0, "revision", 4L);
            UnitTest.mockColumn(columnList0, "active", false);
            UnitTest.mockColumn(columnList0, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList0, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList0, "filter_name", "name");
            UnitTest.mockColumn(columnList0, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList0, "canary", false);
            UnitTest.mockColumn(columnList0, "application_name", "app_name");
            Mockito.when((Object)this.response.getRowByIndex(0)).thenReturn(row0);
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when(iterator.next()).thenReturn(row0);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)1);
            Mockito.when(this.gateway.getByFilterIds(Mockito.anyList())).thenReturn(this.response);
            dao = (ZuulFilterDAO)Mockito.spy((Object)dao);
            ((ZuulFilterDAO)Mockito.doReturn((Object)"name:in_4").when((Object)dao)).getFilterIdsRaw(Matchers.anyString());
            FilterInfo filterInfo = dao.getLatestFilterInfoForFilter(filter);
            Assert.assertEquals((Object)filter, (Object)filterInfo.getFilterID());
            Assert.assertEquals((long)4L, (long)filterInfo.getRevision());
            Assert.assertEquals((Object)false, (Object)filterInfo.isActive());
            Assert.assertEquals((Object)now.getTime(), (Object)filterInfo.getCreationDate());
            Assert.assertEquals((Object)"script body 1", (Object)filterInfo.getFilterCode());
        }

        @Test
        public void testGetActiveScriptForEndpoint() {
            ZuulFilterDAO dao = new ZuulFilterDAOCassandra(this.gateway);
            String filter = "name:in";
            Calendar now = Calendar.getInstance();
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_id", filter);
            UnitTest.mockColumn(columnList0, "revision", 3L);
            UnitTest.mockColumn(columnList0, "active", true);
            UnitTest.mockColumn(columnList0, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList0, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList0, "filter_name", "name");
            UnitTest.mockColumn(columnList0, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList0, "canary", false);
            UnitTest.mockColumn(columnList0, "application_name", "app_name");
            Mockito.when((Object)this.response.getRowByIndex(0)).thenReturn(row0);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)1);
            Mockito.when(this.gateway.getByFilterIds(Mockito.anyList())).thenReturn(this.response);
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when(iterator.next()).thenReturn(row0);
            dao = (ZuulFilterDAO)Mockito.spy((Object)dao);
            ((ZuulFilterDAO)Mockito.doReturn((Object)"name:in_3").when((Object)dao)).getFilterIdsRaw(Matchers.anyString());
            FilterInfo filterInfo = dao.getActiveFilterInfoForFilter(filter);
            Assert.assertEquals((Object)filter, (Object)filterInfo.getFilterID());
            Assert.assertEquals((long)3L, (long)filterInfo.getRevision());
            Assert.assertEquals((Object)true, (Object)filterInfo.isActive());
            Assert.assertEquals((Object)now.getTime(), (Object)filterInfo.getCreationDate());
            Assert.assertEquals((Object)"script body 1", (Object)filterInfo.getFilterCode());
        }

        @Test
        public void testAddScriptForNewEndpointUsingArray() {
            String filter = "null:name:in";
            this.mockGetScriptForEndpoint(filter);
            final StringBuilder upsertedRowKey = new StringBuilder();
            final HashMap upsertedAttributes = new HashMap();
            CassandraGateway testGateway = new CassandraGateway(){

                @Override
                public void upsert(String rowKey, Map<String, Object> attributes) {
                    upsertedRowKey.delete(0, upsertedRowKey.length());
                    upsertedRowKey.append(rowKey);
                    upsertedAttributes.clear();
                    upsertedAttributes.putAll(attributes);
                }

                @Override
                public void updateFilterIndex(String rowKey, String filter_ids) {
                }

                @Override
                public Rows<String, String> select(String cql) {
                    return response;
                }

                @Override
                public Rows<String, String> getByFilterIds(List<String> filterIds) {
                    return null;
                }
            };
            ZuulFilterDAO dao = new ZuulFilterDAOCassandra(testGateway);
            dao = (ZuulFilterDAO)Mockito.spy((Object)dao);
            ((ZuulFilterDAO)Mockito.doReturn((Object)"name:in").when((Object)dao)).getFilterIdsRaw(Matchers.anyString());
            Mockito.when(this.gateway.getByFilterIds(Mockito.anyList())).thenReturn(this.response);
            FilterInfo filterInfo = dao.addFilter("code", FilterType.INBOUND, "name", "disable", "order");
            Assert.assertEquals((Object)(filter + "_1"), (Object)upsertedRowKey.toString());
            Assert.assertEquals((Object)filter, upsertedAttributes.get("filter_id"));
            Assert.assertEquals((Object)1L, upsertedAttributes.get("revision"));
            Assert.assertEquals((Object)false, upsertedAttributes.get("active"));
            Assert.assertTrue((boolean)(upsertedAttributes.get("creation_date") instanceof Date));
            Assert.assertTrue((boolean)Arrays.equals("code".getBytes(), (byte[])upsertedAttributes.get("filter_code")));
        }

        @Test
        public void testAddScriptForExistingEndpoint() {
            String filter = "name:in";
            Calendar now = Calendar.getInstance();
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_id", filter);
            UnitTest.mockColumn(columnList0, "revision", 1L);
            UnitTest.mockColumn(columnList0, "active", false);
            UnitTest.mockColumn(columnList0, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList0, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList0, "filter_name", "name");
            UnitTest.mockColumn(columnList0, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList0, "canary", false);
            UnitTest.mockColumn(columnList0, "application_name", "app_name");
            Mockito.when((Object)this.response.getRowByIndex(0)).thenReturn(row0);
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when(iterator.next()).thenReturn(row0);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)1);
            final StringBuilder upsertedRowKey = new StringBuilder();
            final HashMap upsertedAttributes = new HashMap();
            CassandraGateway testGateway = new CassandraGateway(){

                @Override
                public void upsert(String rowKey, Map<String, Object> attributes) {
                    upsertedRowKey.delete(0, upsertedRowKey.length());
                    upsertedRowKey.append(rowKey);
                    upsertedAttributes.clear();
                    upsertedAttributes.putAll(attributes);
                }

                @Override
                public void updateFilterIndex(String rowKey, String filter_ids) {
                }

                @Override
                public Rows<String, String> select(String cql) {
                    return response;
                }

                @Override
                public Rows<String, String> getByFilterIds(List<String> filterIds) {
                    return null;
                }
            };
            testGateway = (CassandraGateway)Mockito.spy((Object)testGateway);
            ZuulFilterDAO dao = new ZuulFilterDAOCassandra(testGateway);
            dao = (ZuulFilterDAO)Mockito.spy((Object)dao);
            ((ZuulFilterDAO)Mockito.doReturn((Object)"name:in").when((Object)dao)).getFilterIdsRaw(Matchers.anyString());
            ((CassandraGateway)Mockito.doReturn(this.response).when((Object)testGateway)).getByFilterIds(Mockito.anyList());
            FilterInfo filterInfo = dao.addFilter("script body1", FilterType.INBOUND, "name", "disable", "order");
            Assert.assertEquals((Object)("null:" + filter + "_2"), (Object)upsertedRowKey.toString());
            Assert.assertEquals((Object)2L, upsertedAttributes.get("revision"));
        }

        @Test
        public void testSetScriptActive() {
            String filter = "name:in";
            Calendar now = Calendar.getInstance();
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_id", filter);
            UnitTest.mockColumn(columnList0, "revision", 3L);
            UnitTest.mockColumn(columnList0, "active", true);
            UnitTest.mockColumn(columnList0, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList0, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList0, "filter_name", "name");
            UnitTest.mockColumn(columnList0, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList0, "canary", false);
            UnitTest.mockColumn(columnList0, "application_name", "app_name");
            Mockito.when((Object)this.response.getRowByIndex(0)).thenReturn(row0);
            Row<String, String> row1 = UnitTest.mockRow();
            ColumnList<String> columnList1 = UnitTest.mockColumnList(row1);
            UnitTest.mockColumn(columnList1, "filter_id", filter);
            UnitTest.mockColumn(columnList1, "revision", 4L);
            UnitTest.mockColumn(columnList1, "active", false);
            UnitTest.mockColumn(columnList1, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList1, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList1, "filter_name", "name");
            UnitTest.mockColumn(columnList1, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList1, "canary", true);
            UnitTest.mockColumn(columnList1, "application_name", "app_name");
            Mockito.when((Object)this.response.getRowByIndex(1)).thenReturn(row1);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)2);
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
            Mockito.when(iterator.next()).thenReturn(row0, (Object[])new Row[]{row1});
            Rows response2 = (Rows)Mockito.mock(Rows.class);
            Row<String, String> response2row0 = UnitTest.mockRow();
            ColumnList<String> response2columnList1 = UnitTest.mockColumnList(response2row0);
            UnitTest.mockColumn(response2columnList1, "filter_id", filter);
            UnitTest.mockColumn(response2columnList1, "revision", 4L);
            UnitTest.mockColumn(response2columnList1, "active", false);
            UnitTest.mockColumn(response2columnList1, "creation_date", now.getTime());
            UnitTest.mockColumn(response2columnList1, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(response2columnList1, "filter_name", "name");
            UnitTest.mockColumn(response2columnList1, "filter_type", "INBOUND");
            UnitTest.mockColumn(response2columnList1, "canary", true);
            UnitTest.mockColumn(response2columnList1, "application_name", "app_name");
            Mockito.when((Object)response2.getRowByIndex(0)).thenReturn(response2row0);
            Mockito.when((Object)response2.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)response2.size()).thenReturn((Object)1);
            Rows response3 = (Rows)Mockito.mock(Rows.class);
            Row<String, String> response3row0 = UnitTest.mockRow();
            ColumnList<String> response3columnList1 = UnitTest.mockColumnList(response3row0);
            UnitTest.mockColumn(response3columnList1, "filter_id", filter);
            UnitTest.mockColumn(response3columnList1, "revision", 4L);
            UnitTest.mockColumn(response3columnList1, "active", false);
            UnitTest.mockColumn(response3columnList1, "creation_date", now.getTime());
            UnitTest.mockColumn(response3columnList1, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(response3columnList1, "filter_name", "name");
            UnitTest.mockColumn(response3columnList1, "filter_type", "INBOUND");
            UnitTest.mockColumn(response3columnList1, "canary", true);
            UnitTest.mockColumn(response3columnList1, "application_name", "app_name");
            Mockito.when((Object)response3.getRowByIndex(0)).thenReturn(response3row0);
            Mockito.when((Object)response3.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)response3.size()).thenReturn((Object)1);
            Iterator iterator1 = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)response3.iterator()).thenReturn((Object)iterator1);
            Mockito.when((Object)iterator1.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when(iterator1.next()).thenReturn(response3row0);
            ZuulFilterDAOCassandra dao = new ZuulFilterDAOCassandra(this.gateway);
            dao = (ZuulFilterDAOCassandra)Mockito.spy((Object)dao);
            ((ZuulFilterDAOCassandra)Mockito.doReturn((Object)"name:in").when((Object)dao)).getFilterIdsRaw(Matchers.anyString());
            Mockito.when(this.gateway.getByFilterIds(Mockito.anyList())).thenReturn((Object)response3, (Object[])new Rows[]{this.response, response2});
            FilterInfo filterInfo = null;
            try {
                filterInfo = dao.setFilterActive(filter, 4);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.gateway});
            HashMap<String, Object> attributesForActivation = new HashMap<String, Object>();
            attributesForActivation.put("active", true);
            attributesForActivation.put("canary", false);
            ((CassandraGateway)inOrder.verify((Object)this.gateway, Mockito.times((int)1))).upsert(filter + "_4", attributesForActivation);
            HashMap<String, Object> attributesForDeactivation = new HashMap<String, Object>();
            attributesForDeactivation.put("active", false);
            ((CassandraGateway)inOrder.verify((Object)this.gateway)).upsert(filter + "_3", attributesForDeactivation);
        }

        @Test
        public void testSetScriptActiveHandlesPartialFailure() {
            String filter = "name:in";
            Calendar now = Calendar.getInstance();
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_id", filter);
            UnitTest.mockColumn(columnList0, "revision", 3L);
            UnitTest.mockColumn(columnList0, "active", true);
            UnitTest.mockColumn(columnList0, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList0, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList0, "filter_name", "name");
            UnitTest.mockColumn(columnList0, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList0, "canary", false);
            UnitTest.mockColumn(columnList0, "application_name", "app_name");
            Mockito.when((Object)this.response.getRowByIndex(0)).thenReturn(row0);
            Row<String, String> row1 = UnitTest.mockRow();
            ColumnList<String> columnList1 = UnitTest.mockColumnList(row1);
            UnitTest.mockColumn(columnList1, "filter_id", filter);
            UnitTest.mockColumn(columnList1, "revision", 4L);
            UnitTest.mockColumn(columnList1, "active", false);
            UnitTest.mockColumn(columnList1, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList1, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList1, "filter_name", "name");
            UnitTest.mockColumn(columnList1, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList1, "canary", false);
            UnitTest.mockColumn(columnList0, "application_name", "app_name");
            Mockito.when((Object)this.response.getRowByIndex(1)).thenReturn(row1);
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
            Mockito.when(iterator.next()).thenReturn(row0, (Object[])new Row[]{row1});
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)2);
            HashMap<String, Object> attributesForActivation = new HashMap<String, Object>();
            attributesForActivation.put("active", true);
            attributesForActivation.put("canary", false);
            ((CassandraGateway)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.gateway)).upsert(filter + "_4", attributesForActivation);
            ZuulFilterDAO dao = new ZuulFilterDAOCassandra(this.gateway);
            dao = (ZuulFilterDAO)Mockito.spy((Object)dao);
            ((ZuulFilterDAO)Mockito.doReturn((Object)"name:in").when((Object)dao)).getFilterIdsRaw(Matchers.anyString());
            Mockito.when(this.gateway.getByFilterIds(Mockito.anyList())).thenReturn(this.response);
            try {
                dao.setFilterActive(filter, 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HashMap<String, Object> attributesForDeactivation = new HashMap<String, Object>();
            attributesForDeactivation.put("active", false);
            ((CassandraGateway)Mockito.verify((Object)this.gateway, (VerificationMode)Mockito.times((int)0))).upsert(filter + "_3", attributesForDeactivation);
        }

        @Test
        public void testSetScriptActiveDoesNotDeactivateWhatWasJustActivated() {
            String filter = "name:in";
            Calendar now = Calendar.getInstance();
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_id", filter);
            UnitTest.mockColumn(columnList0, "revision", 3L);
            UnitTest.mockColumn(columnList0, "active", true);
            UnitTest.mockColumn(columnList0, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList0, "filter_code", "script body 1".getBytes());
            UnitTest.mockColumn(columnList0, "filter_name", "name");
            UnitTest.mockColumn(columnList0, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList0, "canary", true);
            UnitTest.mockColumn(columnList0, "application_name", "app_name");
            Mockito.when((Object)this.response.getRowByIndex(0)).thenReturn(row0);
            Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
            Mockito.when((Object)this.response.iterator()).thenReturn((Object)iterator);
            Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when(iterator.next()).thenReturn(row0);
            Mockito.when((Object)this.response.isEmpty()).thenReturn((Object)false);
            Mockito.when((Object)this.response.size()).thenReturn((Object)1);
            ZuulFilterDAO dao = new ZuulFilterDAOCassandra(this.gateway);
            dao = (ZuulFilterDAO)Mockito.spy((Object)dao);
            ((ZuulFilterDAO)Mockito.doReturn((Object)"name:in").when((Object)dao)).getFilterIdsRaw(Matchers.anyString());
            Mockito.when(this.gateway.getByFilterIds(Mockito.anyList())).thenReturn(this.response);
            try {
                dao.setFilterActive(filter, 3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.gateway});
            HashMap<String, Object> attributesForActivation = new HashMap<String, Object>();
            attributesForActivation.put("active", true);
            attributesForActivation.put("canary", false);
            ((CassandraGateway)inOrder.verify((Object)this.gateway, Mockito.times((int)1))).upsert(filter + "_3", attributesForActivation);
            HashMap<String, Object> attributesForDeactivation = new HashMap<String, Object>();
            attributesForDeactivation.put("active", false);
            ((CassandraGateway)inOrder.verify((Object)this.gateway, Mockito.times((int)0))).upsert(filter + "_3", attributesForDeactivation);
        }

        private static Column<String> mockColumn(ColumnList<String> columnList, String columnName, Object value) {
            Column column = (Column)Mockito.mock(Column.class);
            if (value instanceof String) {
                Mockito.when((Object)column.getStringValue()).thenReturn((Object)((String)value));
            } else if (value instanceof byte[]) {
                Mockito.when((Object)column.getByteArrayValue()).thenReturn((Object)((byte[])value));
            } else if (value instanceof Date) {
                Mockito.when((Object)column.getDateValue()).thenReturn((Object)((Date)value));
            } else if (value instanceof Integer) {
                Mockito.when((Object)column.getIntegerValue()).thenReturn((Object)((Integer)value));
            } else if (value instanceof Long) {
                Mockito.when((Object)column.getLongValue()).thenReturn((Object)((Long)value));
            } else if (value instanceof Boolean) {
                Mockito.when((Object)column.getBooleanValue()).thenReturn((Object)((Boolean)value));
            } else {
                throw new RuntimeException("unsupported type, add another else above");
            }
            Mockito.when((Object)columnList.getColumnByName((Object)columnName)).thenReturn((Object)column);
            return column;
        }

        private static ColumnList<String> mockColumnList(Row<String, String> row) {
            ColumnList columnList = (ColumnList)Mockito.mock(ColumnList.class);
            Mockito.when((Object)row.getColumns()).thenReturn((Object)columnList);
            return columnList;
        }

        private static Row<String, String> mockRow() {
            Row row0 = (Row)Mockito.mock(Row.class, (String)"row0");
            return row0;
        }

        private void mockGetScriptForEndpoint(String filter) {
            UnitTest.mockGetScriptForEndpoint(this.response, filter);
        }

        private static void mockGetScriptForEndpoint(Rows<String, String> response, String filter) {
            Calendar now = Calendar.getInstance();
            Row<String, String> row0 = UnitTest.mockRow();
            ColumnList<String> columnList0 = UnitTest.mockColumnList(row0);
            UnitTest.mockColumn(columnList0, "filter_id", filter);
            UnitTest.mockColumn(columnList0, "revision", 1L);
            UnitTest.mockColumn(columnList0, "active", false);
            UnitTest.mockColumn(columnList0, "creation_date", now.getTime());
            UnitTest.mockColumn(columnList0, "filter_code", "System.out.println(\"hello world\")".getBytes());
            UnitTest.mockColumn(columnList0, "filter_name", "name");
            UnitTest.mockColumn(columnList0, "filter_type", "INBOUND");
            UnitTest.mockColumn(columnList0, "canary", false);
            Mockito.when((Object)response.getRowByIndex(0)).thenReturn(row0);
            Mockito.when((Object)response.isEmpty()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)response.size()).thenReturn((Object)1);
        }
    }

    @ThreadSafe
    private static class CassandraGatewayProd
    implements CassandraGateway {
        private static final String COLUMN_FAMILY = "zuul_filters";
        private final Keyspace keyspace;

        public CassandraGatewayProd(AstyanaxContext<Keyspace> context) {
            this.keyspace = (Keyspace)context.getClient();
        }

        public CassandraGatewayProd(Keyspace keyspace) {
            this.keyspace = keyspace;
        }

        @Override
        public void updateFilterIndex(String rowKey, String filter_ids) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("index_name", rowKey);
            attributes.put("filter_ids", filter_ids);
            new HystrixCassandraPut<String>(this.keyspace, "zuul_filter_indices", rowKey, attributes).execute();
        }

        @Override
        public void upsert(String rowKey, Map<String, Object> attributes) {
            new HystrixCassandraPut<String>(this.keyspace, COLUMN_FAMILY, rowKey, attributes).execute();
        }

        @Override
        public Rows<String, String> select(String cql) {
            return (Rows)new HystrixCassandraGetRowsByQuery(this.keyspace, COLUMN_FAMILY, String.class, cql).execute();
        }

        @Override
        public Rows<String, String> getByFilterIds(List<String> filterIds) {
            String[] list = new String[filterIds.size()];
            for (int i = 0; i < filterIds.size(); ++i) {
                list[i] = filterIds.get(i);
            }
            return (Rows)new HystrixCassandraGetRowsByKeys<String>(this.keyspace, COLUMN_FAMILY, list).execute();
        }
    }

    private static interface CassandraGateway {
        public void upsert(String var1, Map<String, Object> var2);

        public void updateFilterIndex(String var1, String var2);

        public Rows<String, String> select(String var1);

        public Rows<String, String> getByFilterIds(List<String> var1);
    }
}

