/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.scriptManager;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.scriptManager.FilterInfo;
import com.netflix.zuul.scriptManager.ZuulFilterDAO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZuulFilterPoller {
    Map<String, FilterInfo> runningFilters = new HashMap<String, FilterInfo>();
    ZuulFilterDAO dao;
    DynamicBooleanProperty active = DynamicPropertyFactory.getInstance().getBooleanProperty("zuul.use.active.filters", true);
    DynamicBooleanProperty canary = DynamicPropertyFactory.getInstance().getBooleanProperty("zuul.use.canary.filters", false);
    private static ZuulFilterPoller INSTANCE;
    boolean running = true;
    private long INTERVAL = 30000L;
    Thread checkerThread = new Thread("ZuulFilterPoller"){

        @Override
        public void run() {
            while (ZuulFilterPoller.this.running) {
                try {
                    if (ZuulFilterPoller.this.canary.get()) {
                        List<FilterInfo> canaryScripts;
                        HashMap<String, FilterInfo> setFilters = new HashMap<String, FilterInfo>();
                        List<FilterInfo> activeScripts = ZuulFilterPoller.this.dao.getAllActiveFilters();
                        if (activeScripts != null) {
                            for (FilterInfo newFilter : activeScripts) {
                                setFilters.put(newFilter.getFilterID(), newFilter);
                            }
                        }
                        if ((canaryScripts = ZuulFilterPoller.this.dao.getAllCanaryFilters()) != null) {
                            for (FilterInfo newFilter : canaryScripts) {
                                setFilters.put(newFilter.getFilterID(), newFilter);
                            }
                        }
                        for (FilterInfo next : setFilters.values()) {
                            ZuulFilterPoller.this.doFilterCheck(next);
                        }
                    } else if (ZuulFilterPoller.this.active.get()) {
                        List<FilterInfo> newFilters = ZuulFilterPoller.this.dao.getAllActiveFilters();
                        if (newFilters == null) continue;
                        for (FilterInfo newFilter : newFilters) {
                            ZuulFilterPoller.this.doFilterCheck(newFilter);
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                try {
                    1.sleep(ZuulFilterPoller.this.INTERVAL);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    ZuulFilterPoller.this.running = false;
                }
            }
        }
    };

    public static void start(ZuulFilterDAO dao) {
        INSTANCE = new ZuulFilterPoller(dao);
    }

    public ZuulFilterPoller(ZuulFilterDAO dao) {
        this.dao = dao;
        this.checkerThread.start();
    }

    public static ZuulFilterPoller getInstance() {
        return INSTANCE;
    }

    private void doFilterCheck(FilterInfo newFilter) throws IOException {
        FilterInfo existingFilter = this.runningFilters.get(newFilter.getFilterID());
        if (existingFilter == null || !existingFilter.equals(newFilter)) {
            System.out.println("adding filter to disk" + newFilter.toString());
            this.writeFilterToDisk(newFilter);
            this.runningFilters.put(newFilter.getFilterID(), newFilter);
        }
    }

    private void writeFilterToDisk(FilterInfo newFilter) throws IOException {
        String path = DynamicPropertyFactory.getInstance().getStringProperty("zuul.filter.pre.path", null).get();
        if (newFilter.getFilterType().equals((Object)FilterType.OUTBOUND)) {
            path = DynamicPropertyFactory.getInstance().getStringProperty("zuul.filter.post.path", null).get();
        }
        if (newFilter.getFilterType().equals((Object)FilterType.ENDPOINT)) {
            path = DynamicPropertyFactory.getInstance().getStringProperty("zuul.filter.routing.path", null).get();
        }
        File f = new File(path, newFilter.getFilterName() + ".groovy");
        FileWriter file = new FileWriter(f);
        BufferedWriter out = new BufferedWriter(file);
        out.write(newFilter.getFilterCode());
        out.close();
        file.close();
        System.out.println("filter written " + f.getPath());
    }
}

