/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import com.netflix.config.DynamicStringSetProperty;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameLogger
extends ChannelHandlerAdapter {
    private static final DynamicStringSetProperty FRAMES_TO_LOG = new DynamicStringSetProperty("server.http2.logger.framestolog", "SETTINGS,WINDOW_UPDATE,HEADERS,GO_AWAY,RST_STREAM,PRIORITY,PING,PUSH_PROMISE");
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final InternalLogger logger;
    private final InternalLogLevel level;

    public Http2FrameLogger(LogLevel level) {
        this(level.toInternalLevel(), InternalLoggerFactory.getInstance(Http2FrameLogger.class));
    }

    public Http2FrameLogger(LogLevel level, String name) {
        this(level.toInternalLevel(), InternalLoggerFactory.getInstance((String)name));
    }

    public Http2FrameLogger(LogLevel level, Class<?> clazz) {
        this(level.toInternalLevel(), InternalLoggerFactory.getInstance(clazz));
    }

    private Http2FrameLogger(InternalLogLevel level, InternalLogger logger) {
        this.level = (InternalLogLevel)ObjectUtil.checkNotNull((Object)level, (String)"level");
        this.logger = (InternalLogger)ObjectUtil.checkNotNull((Object)logger, (String)"logger");
    }

    public void logData(Direction direction, ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream) {
        if (this.enabled()) {
            this.log(direction, "DATA", ctx, "streamId=%d, endStream=%b, length=%d", streamId, endStream, data.readableBytes());
        }
    }

    public void logHeaders(Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        if (this.enabled()) {
            this.log(direction, "HEADERS", ctx, "streamId=%d, headers=%s, endStream=%b", streamId, headers, endStream);
        }
    }

    public void logHeaders(Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        if (this.enabled()) {
            this.log(direction, "HEADERS", ctx, "streamId=%d, headers=%s, streamDependency=%d, weight=%d, exclusive=%b, endStream=%b", streamId, headers, streamDependency, weight, exclusive, endStream);
        }
    }

    public void logPriority(Direction direction, ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        if (this.enabled()) {
            this.log(direction, "PRIORITY", ctx, "streamId=%d, streamDependency=%d, weight=%d, exclusive=%b", streamId, streamDependency, weight, exclusive);
        }
    }

    public void logRstStream(Direction direction, ChannelHandlerContext ctx, int streamId, long errorCode) {
        if (this.enabled()) {
            this.log(direction, "RST_STREAM", ctx, "streamId=%d, errorCode=%d", streamId, errorCode);
        }
    }

    public void logSettingsAck(Direction direction, ChannelHandlerContext ctx) {
        if (this.enabled()) {
            this.log(direction, "SETTINGS", ctx, "ack=true", new Object[0]);
        }
    }

    public void logSettings(Direction direction, ChannelHandlerContext ctx, Http2Settings settings) {
        if (this.enabled()) {
            this.log(direction, "SETTINGS", ctx, "ack=false, settings=%s", settings);
        }
    }

    public void logPing(Direction direction, ChannelHandlerContext ctx, ByteBuf data) {
        if (this.enabled()) {
            this.log(direction, "PING", ctx, "ack=false, length=%d, bytes=%s", data.readableBytes(), this.toString(data));
        }
    }

    public void logPingAck(Direction direction, ChannelHandlerContext ctx, ByteBuf data) {
        if (this.enabled()) {
            this.log(direction, "PING", ctx, "ack=true, length=%d, bytes=%s", data.readableBytes(), this.toString(data));
        }
    }

    public void logPushPromise(Direction direction, ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        if (this.enabled()) {
            this.log(direction, "PUSH_PROMISE", ctx, "streamId=%d, promisedStreamId=%d, headers=%s, padding=%d", streamId, promisedStreamId, headers, padding);
        }
    }

    public void logGoAway(Direction direction, ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (this.enabled()) {
            this.log(direction, "GO_AWAY", ctx, "lastStreamId=%d, errorCode=%d, length=%d, bytes=%s", lastStreamId, errorCode, debugData.readableBytes(), this.toString(debugData));
        }
    }

    public void logWindowsUpdate(Direction direction, ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
        if (this.enabled()) {
            this.log(direction, "WINDOW_UPDATE", ctx, "streamId=%d, windowSizeIncrement=%d", streamId, windowSizeIncrement);
        }
    }

    public void logUnknownFrame(Direction direction, ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf data) {
        if (this.enabled()) {
            this.log(direction, "UNKNOWN", ctx, "frameType=%d, streamId=%d, flags=%d, length=%d, bytes=%s", frameType & 0xFF, streamId, flags.value(), data.readableBytes(), this.toString(data));
        }
    }

    protected boolean enabled() {
        return this.logger.isEnabled(this.level);
    }

    private String toString(ByteBuf buf) {
        if (this.level == InternalLogLevel.TRACE || buf.readableBytes() <= 64) {
            return ByteBufUtil.hexDump((ByteBuf)buf);
        }
        int length = Math.min(buf.readableBytes(), 64);
        return ByteBufUtil.hexDump((ByteBuf)buf, (int)buf.readerIndex(), (int)length) + "...";
    }

    private void log(Direction direction, String frame, ChannelHandlerContext ctx, String format, Object ... args) {
        if (this.shouldLogFrame(frame)) {
            StringBuilder b = new StringBuilder(200).append(direction.name()).append(": ").append(frame).append(": ").append(String.format(format, args)).append(" -- ").append(String.valueOf(ctx.channel()));
            this.logger.log(this.level, b.toString());
        }
    }

    protected boolean shouldLogFrame(String frame) {
        return FRAMES_TO_LOG.get().contains(frame);
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

