/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.AgentCommandLineParser;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.install.ConfigInstaller;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceManagerImpl;
import java.lang.instrument.Instrumentation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;

public final class Agent
extends AbstractService
implements IAgent {
    public static final IAgentLogger LOG = AgentLogManager.getLogger();
    private static final String AGENT_ENABLED_PROPERTY = "newrelic.config.agent_enabled";
    private static final boolean DEBUG = Boolean.getBoolean("newrelic.debug");
    private static final String VERSION = Agent.initVersion();
    private volatile boolean enabled = true;
    private final Instrumentation instrumentation;
    private volatile InstrumentationProxy instrumentationProxy;

    private Agent(Instrumentation instrumentation) {
        super(IAgent.class.getSimpleName());
        this.instrumentation = instrumentation;
    }

    protected void doStart() {
        ConfigService configService = ServiceFactory.getConfigService();
        IAgentConfig config = configService.getDefaultAgentConfig();
        AgentLogManager.configureLogger(config);
        this.logHostIp();
        this.enabled = config.isAgentEnabled();
        if (!this.enabled) {
            LOG.info("New Relic agent is disabled");
        }
        this.instrumentationProxy = InstrumentationProxy.getInstrumentationProxy(this.instrumentation);
        final long startTime = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            public void run() {
                Agent.this.jvmShutdown(startTime);
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic JVM Shutdown");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    private void logHostIp() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            LOG.info("Agent Host: " + address.getHostName() + " IP: " + address.getHostAddress());
        }
        catch (UnknownHostException e) {
            LOG.info("New Relic could not identify host/ip.");
        }
    }

    protected void doStop() {
    }

    public void shutdownAsync() {
        Runnable runnable = new Runnable(){

            public void run() {
                Agent.this.shutdown();
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic Shutdown");
        shutdownThread.start();
    }

    private void jvmShutdown(long startTime) {
        IAgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        if (config.isSendDataOnExit() && System.currentTimeMillis() - startTime > config.getSendDataOnExitThresholdInMillis()) {
            ServiceFactory.getHarvestService().harvestNow();
        }
        this.getLogger().info("JVM is shutting down");
        this.shutdown();
    }

    public synchronized void shutdown() {
        try {
            ServiceFactory.getServiceManager().stop();
            this.getLogger().info("New Relic Agent has shutdown");
        }
        catch (Exception e) {
            LOG.severe(MessageFormat.format("Error shutting down New Relic Agent: {0}", e));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public InstrumentationProxy getInstrumentation() {
        return this.instrumentationProxy;
    }

    public static String getVersion() {
        return VERSION;
    }

    private static String initVersion() {
        try {
            String agentVersion = AgentJarHelper.getAgentJarAttribute("Agent-Version");
            if (agentVersion != null) {
                return agentVersion;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(Agent.class.getName());
            return bundle.getString("version");
        }
        catch (Throwable throwable) {
            return "0.0";
        }
    }

    public static boolean isDebugEnabled() {
        return DEBUG;
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        if (ServiceFactory.getServiceManager() != null) {
            System.err.println("New Relic Agent is already running! Check if more than one -javaagent switch is used on the command line");
            return;
        }
        String enabled = System.getProperty(AGENT_ENABLED_PROPERTY);
        if (enabled != null && !Boolean.parseBoolean(enabled.toString())) {
            System.out.println("New Relic agent is disabled");
            return;
        }
        try {
            Agent agent = new Agent(inst);
            ServiceManagerImpl serviceManager = new ServiceManagerImpl(agent);
            ServiceFactory.setServiceManager(serviceManager);
            if (ConfigInstaller.isLicenseKeyEmpty(serviceManager.getConfigService().getDefaultAgentConfig().getLicenseKey())) {
                LOG.error("license_key is empty in the config, not starting New Relic Agent");
                return;
            }
            if (!serviceManager.getConfigService().getDefaultAgentConfig().isAgentEnabled()) {
                LOG.info("agent_enabled is false in the config, not starting New Relic Agent");
                return;
            }
            serviceManager.start();
            LOG.info(MessageFormat.format("New Relic Agent v{0} has started", Agent.getVersion()));
            LOG.config(MessageFormat.format("Java version: {0}", System.getProperty("java.version")));
            LOG.info("Agent class loader: " + Agent.class.getClassLoader());
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Unable to start New Relic agent: {0}", t);
            try {
                LOG.log(Level.SEVERE, msg, t);
            }
            catch (Throwable t2) {
                // empty catch block
            }
            System.err.println(msg);
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new AgentCommandLineParser().parseCommand(args);
    }
}

