/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment
implements JSONStreamAware,
Cloneable {
    private static final Pattern JSON_WORKAROUND = Pattern.compile("\\\\+$");
    private List<List> environmentMap = new ArrayList<List>();
    private String dispatcher;
    private volatile boolean serverInfoSet;
    private String dispatcherVersion;
    private volatile Integer serverPort;

    public Environment(IAgentConfig config, String logFilePath) {
        if (config.isSendEnvironmentInfo()) {
            OperatingSystemMXBean systemMXBean = ManagementFactory.getOperatingSystemMXBean();
            this.addVariable("Processors", systemMXBean.getAvailableProcessors());
            this.addVariable("Arch", systemMXBean.getArch());
            this.addVariable("OS version", systemMXBean.getVersion());
            this.addVariable("OS", systemMXBean.getName());
            this.addVariable("Java vendor", System.getProperty("java.vendor"));
            this.addVariable("Java version", System.getProperty("java.version"));
            this.addVariable("Log path", logFilePath);
            MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            this.addVariable("Heap initial (MB)", Float.valueOf((float)heapMemoryUsage.getInit() / 1048576.0f));
            this.addVariable("Heap max (MB)", Float.valueOf((float)heapMemoryUsage.getMax() / 1048576.0f));
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> inputArguments = Environment.fixInputArguments(runtimeMXBean.getInputArguments());
            this.environmentMap.add(Arrays.asList("JVM arguments", inputArguments));
        }
        this.dispatcher = System.getProperty("com.sun.aas.installRoot") != null ? "Glassfish" : (System.getProperty("resin.home") != null ? "Resin" : (System.getProperty("org.apache.geronimo.base.dir") != null ? "Apache Geronimo" : (System.getProperty("weblogic.home") != null ? "WebLogic" : (System.getProperty("was.install.root") != null ? "IBM WebSphere Application Server" : (System.getProperty("jboss.home") != null ? "JBoss" : (System.getProperty("catalina.home") != null ? "Apache Tomcat" : (System.getProperty("jetty.home") != null ? "Jetty" : "Unknown")))))));
        this.addVariable("Framework", "java");
        Number appServerPort = (Number)config.getProperty("appserver_port");
        if (appServerPort != null) {
            this.serverPort = appServerPort.intValue();
        }
    }

    private static List<String> fixInputArguments(List<String> args) {
        ArrayList<String> fixed = new ArrayList<String>(args.size());
        for (String arg : args) {
            fixed.add(Environment.fixString(arg));
        }
        return fixed;
    }

    static String fixString(String arg) {
        Matcher matcher = JSON_WORKAROUND.matcher(arg);
        return matcher.replaceAll("");
    }

    public void setServerPort(Integer port) {
        this.serverPort = port;
    }

    public final Integer getServerPort() {
        return this.serverPort;
    }

    public void setDispatcher(String name) {
        this.dispatcher = name;
    }

    public void setDispatcherVersion(String version) {
        this.dispatcherVersion = version;
    }

    public String getDispatcher() {
        return this.dispatcher;
    }

    public String getDispatcherVersion() {
        return this.dispatcherVersion;
    }

    public void addVariable(String name, Object value) {
        this.environmentMap.add(Arrays.asList(name, value));
    }

    public Object getVariable(String name) {
        for (List item : this.environmentMap) {
            if (!name.equals(item.get(0))) continue;
            return item.get(1);
        }
        return null;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        ArrayList<List> map = new ArrayList<List>(this.environmentMap);
        map.add(Arrays.asList("Dispatcher", this.dispatcher));
        if (this.dispatcherVersion != null) {
            map.add(Arrays.asList("Dispatcher Version", this.dispatcherVersion));
        }
        if (this.serverPort != null) {
            map.add(Arrays.asList("Server port", this.serverPort));
        }
        JSONArray.writeJSONString(map, writer);
    }

    public void setServerInfo(String serverInfo) {
        Agent.LOG.config("Server Info: " + serverInfo);
        this.serverInfoSet = true;
        String[] info = serverInfo.split("/");
        if (info.length == 2) {
            this.setDispatcher(info[0]);
            this.setDispatcherVersion(info[1]);
        }
    }

    public boolean isServerInfoSet() {
        return this.serverInfoSet;
    }

    public Environment clone() throws CloneNotSupportedException {
        Environment env = (Environment)super.clone();
        env.serverPort = this.serverPort;
        env.dispatcher = this.dispatcher;
        env.dispatcherVersion = this.dispatcherVersion;
        env.serverInfoSet = this.serverInfoSet;
        env.environmentMap = new ArrayList<List>(this.environmentMap);
        return env;
    }
}

